/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jpa.impl.score;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class AbstractScoreHibernateType
implements CompositeUserType {
    protected ScoreDefinition scoreDefinition;
    protected AbstractSingleColumnStandardBasicType type;

    protected int extractIntParameter(Properties parameterMap, String parameterName) {
        String valueString = (String)parameterMap.get(parameterName);
        if (valueString == null) {
            throw new IllegalArgumentException("The parameter " + parameterName + " (" + valueString + ") is missing for " + this.getClass().getSimpleName() + ".");
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The parameter " + parameterName + " (" + valueString + ") is not a valid integer for " + this.getClass().getSimpleName() + ".");
        }
    }

    public Class returnedClass() {
        return this.scoreDefinition.getClass();
    }

    public String[] getPropertyNames() {
        int levelsSize = this.scoreDefinition.getLevelsSize();
        String[] levelLabels = this.scoreDefinition.getLevelLabels();
        String[] propertyNames = new String[levelsSize];
        for (int i = 0; i < levelsSize; ++i) {
            String propertyName = levelLabels[i].replaceAll("\\s+s", "S").replaceAll("\\s+(\\d)", "$1");
            if (!propertyName.matches("[\\w\\d]+")) {
                throw new IllegalStateException("The levelLabel (" + levelLabels[i] + ") is not yet supported.");
            }
            propertyNames[i] = propertyName;
        }
        return propertyNames;
    }

    public Type[] getPropertyTypes() {
        int levelsSize = this.scoreDefinition.getLevelsSize();
        Type[] propertyTypes = new Type[levelsSize];
        for (int i = 0; i < levelsSize; ++i) {
            propertyTypes[i] = this.type;
        }
        return propertyTypes;
    }

    public Object getPropertyValue(Object o, int propertyIndex) {
        if (o == null) {
            return null;
        }
        Score score = (Score)o;
        Number[] levelNumbers = score.toLevelNumbers();
        if (propertyIndex >= this.scoreDefinition.getLevelsSize()) {
            throw new IllegalArgumentException("The propertyIndex (" + propertyIndex + ") must be lower than the levelsSize for score (" + score + ").");
        }
        return levelNumbers[propertyIndex];
    }

    public Score nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor session, Object owner) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        int levelsSize = this.scoreDefinition.getLevelsSize();
        Object[] levelNumbers = new Number[levelsSize];
        int nullCount = 0;
        for (int i = 0; i < levelsSize; ++i) {
            Number levelNumber = (Number)this.type.nullSafeGet(resultSet, names[i], session, owner);
            if (levelNumber == null) {
                ++nullCount;
                continue;
            }
            levelNumbers[i] = levelNumber;
        }
        if (nullCount == levelsSize) {
            return null;
        }
        if (nullCount != 0) {
            throw new IllegalStateException("The nullCount (" + nullCount + ") must be 0 or levelsSize (" + levelsSize + ") for " + this.getClass().getSimpleName() + ".");
        }
        Score score = this.scoreDefinition.fromLevelNumbers((Number[])levelNumbers);
        if (score == null) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ") must not build a score (" + null + ") that is null.");
        }
        return score;
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int parameterIndex, SessionImplementor session) throws SQLException {
        int levelsSize = this.scoreDefinition.getLevelsSize();
        if (value == null) {
            for (int i = 0; i < levelsSize; ++i) {
                statement.setNull(parameterIndex + i, this.type.sqlType());
            }
            return;
        }
        Score score = (Score)value;
        Number[] levelNumbers = score.toLevelNumbers();
        if (levelNumbers.length != levelsSize) {
            throw new IllegalStateException("The levelNumbers length (" + levelNumbers.length + ") for score (" + score + ") must be equal to the levelsSize (" + levelsSize + ") for " + this.getClass().getSimpleName() + ".");
        }
        for (int i = 0; i < levelsSize; ++i) {
            if (this.type == IntegerType.INSTANCE) {
                statement.setInt(parameterIndex + i, (Integer)levelNumbers[i]);
                continue;
            }
            if (this.type == LongType.INSTANCE) {
                statement.setLong(parameterIndex + i, (Long)levelNumbers[i]);
                continue;
            }
            if (this.type == DoubleType.INSTANCE) {
                statement.setDouble(parameterIndex + i, (Double)levelNumbers[i]);
                continue;
            }
            if (this.type == BigDecimalType.INSTANCE) {
                statement.setBigDecimal(parameterIndex + i, (BigDecimal)levelNumbers[i]);
                continue;
            }
            throw new IllegalStateException("The type (" + this.type + ") is not yet supported.");
        }
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) {
        return original;
    }

    public void setPropertyValue(Object component, int property, Object value) {
        throw new UnsupportedOperationException("A Score is immutable.");
    }

    public boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public Serializable disassemble(Object value, SessionImplementor session) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) {
        return cached;
    }
}

