/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.impl.score;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.definition.AbstractBendableScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class XStreamScoreConverter
implements Converter {
    private final ScoreDefinition scoreDefinition;

    public XStreamScoreConverter(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public XStreamScoreConverter(Class<? extends Score> scoreClass, Class<? extends ScoreDefinition> scoreDefinitionClass) {
        if (AbstractBendableScoreDefinition.class.isAssignableFrom(scoreDefinitionClass)) {
            throw new IllegalArgumentException("This constructor is not compatible with scoreClass (" + scoreClass + "), use the other constructor with 2 int parameters instead.");
        }
        try {
            this.scoreDefinition = scoreDefinitionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("The scoreDefinitionClass (" + scoreDefinitionClass + ") does not have a public no-arg constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The scoreDefinitionClass (" + scoreDefinitionClass + ") does not have a public no-arg constructor", e);
        }
        if (scoreClass != this.scoreDefinition.getScoreClass()) {
            throw new IllegalStateException("The scoreClass (" + scoreClass + ") of the Score field to serialize to XML does not match the scoreDefinition's scoreClass (" + this.scoreDefinition.getScoreClass() + ").");
        }
    }

    public XStreamScoreConverter(Class<? extends Score> scoreClass, Class<? extends ScoreDefinition> scoreDefinitionClass, int hardLevelsSize, int softLevelsSize) {
        if (!AbstractBendableScoreDefinition.class.isAssignableFrom(scoreDefinitionClass)) {
            throw new IllegalArgumentException("This constructor is not compatible with scoreClass (" + scoreClass + "), use the other constructor with no int parameters instead.");
        }
        if (BendableScoreDefinition.class.equals(scoreDefinitionClass)) {
            this.scoreDefinition = new BendableScoreDefinition(hardLevelsSize, softLevelsSize);
        } else if (BendableLongScoreDefinition.class.equals(scoreDefinitionClass)) {
            this.scoreDefinition = new BendableLongScoreDefinition(hardLevelsSize, softLevelsSize);
        } else if (BendableBigDecimalScoreDefinition.class.equals(scoreDefinitionClass)) {
            this.scoreDefinition = new BendableBigDecimalScoreDefinition(hardLevelsSize, softLevelsSize);
        } else {
            throw new IllegalArgumentException("The scoreDefinitionClass (" + scoreDefinitionClass + ") is not yet supported in " + this.getClass().getSimpleName() + ".");
        }
        if (scoreClass != this.scoreDefinition.getScoreClass()) {
            throw new IllegalStateException("The scoreClass (" + scoreClass + ") of the Score field to serialize to XML does not match the scoreDefinition's scoreClass (" + this.scoreDefinition.getScoreClass() + ").");
        }
    }

    public boolean canConvert(Class type) {
        return this.scoreDefinition.getScoreClass().isAssignableFrom(type);
    }

    public void marshal(Object scoreObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        String scoreString = this.scoreDefinition.formatScore((Score)scoreObject);
        writer.setValue(scoreString);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String scoreString = reader.getValue();
        return this.scoreDefinition.parseScore(scoreString);
    }
}

