/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.quarkus;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Supplier;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.quarkus.config.OptaPlannerBenchmarkRuntimeConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

@Recorder
public class OptaPlannerBenchmarkRecorder {
    public Supplier<PlannerBenchmarkConfig> benchmarkConfigSupplier(PlannerBenchmarkConfig benchmarkConfig) {
        return () -> {
            OptaPlannerBenchmarkRuntimeConfig optaPlannerRuntimeConfig = (OptaPlannerBenchmarkRuntimeConfig)Arc.container().instance(OptaPlannerBenchmarkRuntimeConfig.class, new Annotation[0]).get();
            SolverConfig solverConfig = (SolverConfig)Arc.container().instance(SolverConfig.class, new Annotation[0]).get();
            this.updateBenchmarkConfigWithRuntimeProperties(benchmarkConfig, optaPlannerRuntimeConfig, solverConfig);
            return benchmarkConfig;
        };
    }

    private void updateBenchmarkConfigWithRuntimeProperties(PlannerBenchmarkConfig plannerBenchmarkConfig, OptaPlannerBenchmarkRuntimeConfig benchmarkRuntimeConfig, SolverConfig solverConfig) {
        if (plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig() == null) {
            ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
            SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
            SolverConfig benchmarkSolverConfig = new SolverConfig();
            benchmarkSolverConfig.inherit(solverConfig);
            solverBenchmarkConfig.setSolverConfig(benchmarkSolverConfig);
            solverBenchmarkConfig.setProblemBenchmarksConfig(problemBenchmarksConfig);
            plannerBenchmarkConfig.setBenchmarkDirectory(new File(benchmarkRuntimeConfig.resultDirectory));
            plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(solverBenchmarkConfig);
        }
        TerminationConfig terminationConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig();
        benchmarkRuntimeConfig.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        benchmarkRuntimeConfig.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        benchmarkRuntimeConfig.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
        if (!this.isTerminationConfigured(terminationConfig)) {
            throw new IllegalStateException("At least one of the properties quarkus.optaplanner.benchmark.solver.termination.spent-limit, quarkus.optaplanner.benchmark.solver.termination.best-score-limit, quarkus.optaplanner.benchmark.solver.termination.unimproved-spent-limit is required if the inherited solver config does not have termination configured.");
        }
        if (plannerBenchmarkConfig.getSolverBenchmarkConfigList() == null && plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() == null) {
            plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        }
    }

    private boolean isTerminationConfigured(TerminationConfig terminationConfig) {
        return terminationConfig.getTerminationClass() != null || terminationConfig.getSpentLimit() != null || terminationConfig.getBestScoreLimit() != null || terminationConfig.getUnimprovedSpentLimit() != null || terminationConfig.getStepCountLimit() != null || terminationConfig.getTerminationConfigList() != null;
    }
}

