/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerImplementor;
import org.optaplanner.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.drools.KieBaseExtractor;
import org.optaplanner.quarkus.gizmo.OptaPlannerDroolsInitializer;
import org.optaplanner.quarkus.gizmo.OptaPlannerGizmoBeanFactory;

public class GizmoMemberAccessorEntityEnhancer {
    private static Set<Field> visitedFields = new HashSet<Field>();
    private static Set<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
    private static final String DROOLS_INITIALIZER_CLASS_NAME = OptaPlannerDroolsInitializer.class.getName() + "$Implementation";

    public static void addVirtualFieldGetter(ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
        Field field = clazz.getDeclaredField(fieldInfo.name());
        GizmoMemberAccessorEntityEnhancer.addVirtualFieldGetter(clazz, field, transformers);
    }

    public static void addVirtualFieldGetter(Class<?> classInfo, Field fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedFields.contains(fieldInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.getName(), (className, classVisitor) -> new OptaPlannerFieldEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, fieldInfo)));
            visitedFields.add(fieldInfo);
        }
    }

    public static Optional<MethodDescriptor> addVirtualMethodGetter(ClassInfo classInfo, MethodInfo methodInfo, String name, Optional<MethodDescriptor> setterDescriptor, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedMethods.contains(methodInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new OptaPlannerMethodEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, methodInfo, name, setterDescriptor)));
            visitedMethods.add(methodInfo);
        }
        return setterDescriptor.map(md -> MethodDescriptor.ofMethod((String)classInfo.name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, name), (String)md.getReturnType(), (String[])md.getParameterTypes()));
    }

    public static String getVirtualGetterName(boolean isField, String name) {
        return "$get$optaplanner$__" + (isField ? "field$__" : "method$__") + name;
    }

    public static String getVirtualSetterName(boolean isField, String name) {
        return "$set$optaplanner$__" + (isField ? "field$__" : "method$__") + name;
    }

    public static String generateFieldAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> declaringClass = Class.forName(fieldInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Field fieldMember = declaringClass.getDeclaredField(fieldInfo.name());
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)fieldMember);
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).setFinal(true).build();){
            GizmoMemberDescriptor member;
            FieldDescriptor memberDescriptor = FieldDescriptor.of((FieldInfo)fieldInfo);
            String name = fieldInfo.name();
            if (Modifier.isPublic(fieldInfo.flags())) {
                member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, (Object)memberDescriptor, declaringClass);
            } else {
                GizmoMemberAccessorEntityEnhancer.addVirtualFieldGetter(classInfo, fieldInfo, transformers);
                String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, fieldInfo.name());
                MethodDescriptor getterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)methodName, (String)fieldInfo.type().name().toString(), (String[])new String[0]);
                MethodDescriptor setterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, fieldInfo.name()), (String)"void", (String[])new String[]{fieldInfo.type().name().toString()});
                member = new GizmoMemberDescriptor(name, (Object)getterDescriptor, (Object)memberDescriptor, declaringClass, setterDescriptor);
            }
            GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        }
        return generatedClassName;
    }

    private static String getMemberName(Member member) {
        return (String)ObjectUtils.defaultIfNull((Object)ReflectionHelper.getGetterPropertyName((Member)member), (Object)member.getName());
    }

    private static Optional<MethodDescriptor> getSetterDescriptor(ClassInfo classInfo, MethodInfo methodInfo, String name) {
        if (methodInfo.name().startsWith("get") || methodInfo.name().startsWith("is")) {
            return Optional.ofNullable(classInfo.method("set" + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1), new org.jboss.jandex.Type[]{methodInfo.returnType()})).map(MethodDescriptor::of);
        }
        return Optional.empty();
    }

    public static String generateMethodAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> declaringClass = Class.forName(methodInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Method methodMember = declaringClass.getDeclaredMethod(methodInfo.name(), new Class[0]);
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)methodMember);
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).setFinal(true).build();){
            GizmoMemberDescriptor member;
            String name = GizmoMemberAccessorEntityEnhancer.getMemberName(methodMember);
            Optional<MethodDescriptor> setterDescriptor = GizmoMemberAccessorEntityEnhancer.getSetterDescriptor(classInfo, methodInfo, name);
            MethodDescriptor memberDescriptor = MethodDescriptor.of((MethodInfo)methodInfo);
            if (Modifier.isPublic(methodInfo.flags())) {
                member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, (Object)memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
            } else {
                setterDescriptor = GizmoMemberAccessorEntityEnhancer.addVirtualMethodGetter(classInfo, methodInfo, name, setterDescriptor, transformers);
                String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, name);
                MethodDescriptor newMethodDescriptor = MethodDescriptor.ofMethod(declaringClass, (String)methodName, (Object)memberDescriptor.getReturnType(), (Object[])new Object[0]);
                member = new GizmoMemberDescriptor(name, (Object)newMethodDescriptor, (Object)memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
            }
            GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        }
        return generatedClassName;
    }

    public static String generateSolutionCloner(SolutionDescriptor solutionDescriptor, ClassOutput classOutput, IndexView indexView, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        String generatedClassName = GizmoSolutionClonerFactory.getGeneratedClassName((SolutionDescriptor)solutionDescriptor);
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{SolutionCloner.class}).classOutput(classOutput).setFinal(true).build();){
            HashMap memoizedGizmoSolutionOrEntityDescriptorForClassMap = new HashMap();
            List solutionSubclassesList = indexView.getAllKnownSubclasses(DotName.createSimple((String)solutionDescriptor.getSolutionClass().getName())).stream().map(classInfo -> {
                try {
                    return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to find class (" + classInfo.name() + "), which is a known subclass of the solution class (" + solutionDescriptor.getSolutionClass() + ").", e);
                }
            }).collect(Collectors.toCollection(ArrayList::new));
            solutionSubclassesList.add(solutionDescriptor.getSolutionClass());
            for (Class solutionSubclass : solutionSubclassesList) {
                GizmoMemberAccessorEntityEnhancer.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, solutionSubclass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            for (Object entityClass : solutionDescriptor.getEntityClassSet()) {
                GizmoMemberAccessorEntityEnhancer.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, (Class)entityClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            DeepCloningUtils deepCloningUtils = new DeepCloningUtils(solutionDescriptor);
            HashSet solutionAndEntitySubclassSet = new HashSet(solutionSubclassesList);
            for (Object entityClassObject : solutionDescriptor.getEntityClassSet()) {
                Class entityClass = (Class)entityClassObject;
                Collection classInfoCollection = indexView.getAllKnownSubclasses(DotName.createSimple((String)entityClass.getName()));
                classInfoCollection.stream().map(classInfo -> {
                    try {
                        return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to find class (" + classInfo.name() + "), which is a known subclass of the entity class (" + entityClass + ").", e);
                    }
                }).forEach(solutionAndEntitySubclassSet::add);
            }
            Set deepClonedClassSet = deepCloningUtils.getDeepClonedClasses(solutionAndEntitySubclassSet);
            for (Class deepCloningClass : deepClonedClassSet) {
                if (memoizedGizmoSolutionOrEntityDescriptorForClassMap.containsKey(deepCloningClass)) continue;
                GizmoMemberAccessorEntityEnhancer.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, deepCloningClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            GizmoSolutionClonerImplementor.defineClonerFor((ClassCreator)classCreator, (SolutionDescriptor)solutionDescriptor, (List)solutionSubclassesList, memoizedGizmoSolutionOrEntityDescriptorForClassMap, (Set)deepClonedClassSet);
        }
        return generatedClassName;
    }

    private static GizmoSolutionOrEntityDescriptor getGizmoSolutionOrEntityDescriptorForEntity(SolutionDescriptor solutionDescriptor, Class<?> entityClass, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedMap, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        HashMap<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptor = new HashMap<Field, GizmoMemberDescriptor>();
        for (Class<?> currentClass = entityClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                GizmoMemberDescriptor member;
                if (Modifier.isStatic(field.getModifiers())) continue;
                Class<?> declaringClass = field.getDeclaringClass();
                FieldDescriptor memberDescriptor = FieldDescriptor.of((Field)field);
                String name = field.getName();
                if (Modifier.isPublic(field.getModifiers())) {
                    member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, (Object)memberDescriptor, declaringClass);
                } else {
                    GizmoMemberAccessorEntityEnhancer.addVirtualFieldGetter(declaringClass, field, transformers);
                    String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, field.getName());
                    MethodDescriptor getterDescriptor = MethodDescriptor.ofMethod((Object)field.getDeclaringClass().getName(), (String)methodName, field.getType(), (Object[])new Object[0]);
                    MethodDescriptor setterDescriptor = MethodDescriptor.ofMethod((Object)field.getDeclaringClass().getName(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, field.getName()), (Object)"void", (Object[])new Object[]{field.getType()});
                    member = new GizmoMemberDescriptor(name, (Object)getterDescriptor, (Object)memberDescriptor, declaringClass, setterDescriptor);
                }
                solutionFieldToMemberDescriptor.put(field, member);
            }
        }
        GizmoSolutionOrEntityDescriptor out = new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass, solutionFieldToMemberDescriptor);
        memoizedMap.put(entityClass, out);
        return out;
    }

    public static Map<String, RuntimeValue<MemberAccessor>> getGeneratedGizmoMemberAccessorMap(RecorderContext recorderContext, Set<String> generatedMemberAccessorsClassNames) {
        HashMap<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorNameToInstanceMap = new HashMap<String, RuntimeValue<MemberAccessor>>();
        for (String className : generatedMemberAccessorsClassNames) {
            generatedGizmoMemberAccessorNameToInstanceMap.put(className, (RuntimeValue<MemberAccessor>)recorderContext.newInstance(className));
        }
        return generatedGizmoMemberAccessorNameToInstanceMap;
    }

    public static Map<String, RuntimeValue<SolutionCloner>> getGeneratedSolutionClonerMap(RecorderContext recorderContext, Set<String> generatedSolutionClonersClassNames) {
        HashMap<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerNameToInstanceMap = new HashMap<String, RuntimeValue<SolutionCloner>>();
        for (String className : generatedSolutionClonersClassNames) {
            generatedGizmoSolutionClonerNameToInstanceMap.put(className, (RuntimeValue<SolutionCloner>)recorderContext.newInstance(className));
        }
        return generatedGizmoSolutionClonerNameToInstanceMap;
    }

    public static String generateGizmoBeanFactory(ClassOutput classOutput, Set<Class<?>> beanClasses) {
        String generatedClassName = OptaPlannerGizmoBeanFactory.class.getName() + "$Implementation";
        ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{OptaPlannerGizmoBeanFactory.class}).classOutput(classOutput).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(OptaPlannerGizmoBeanFactory.class, (String)"newInstance", Object.class, (Class[])new Class[]{Class.class}));
        ResultHandle query = methodCreator.getMethodParam(0);
        MethodCreator currentBranch = methodCreator;
        for (Class<?> beanClass : beanClasses) {
            ResultHandle beanClassHandle = currentBranch.loadClass(beanClass);
            ResultHandle isTarget = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), beanClassHandle, new ResultHandle[]{query});
            BranchResult isQueryBranchResult = currentBranch.ifTrue(isTarget);
            BytecodeCreator isQueryBranch = isQueryBranchResult.trueBranch();
            ResultHandle beanInstance = isQueryBranch.newInstance(MethodDescriptor.ofConstructor(beanClass, (Class[])new Class[0]), new ResultHandle[0]);
            isQueryBranch.returnValue(beanInstance);
            currentBranch = isQueryBranchResult.falseBranch();
        }
        currentBranch.returnValue(currentBranch.loadNull());
        classCreator.close();
        return generatedClassName;
    }

    public static String generateKieRuntimeBuilder(ClassOutput classOutput, ScoreDirectorFactoryConfig config, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        String generatedClassName = DROOLS_INITIALIZER_CLASS_NAME;
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{OptaPlannerDroolsInitializer.class}).classOutput(classOutput).build();){
            MethodCreator methodCreator;
            classCreator.addAnnotation(ApplicationScoped.class);
            if (!ConfigUtils.isEmptyCollection((Collection)config.getScoreDrlList()) || !ConfigUtils.isEmptyCollection((Collection)config.getScoreDrlFileList())) {
                unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{KieRuntimeBuilder.class}));
                methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(OptaPlannerDroolsInitializer.class, (String)"setup", Void.TYPE, (Class[])new Class[]{ScoreDirectorFactoryConfig.class}));
                ResultHandle cdiResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(CDI.class, (String)"current", CDI.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle beanManagerResultHandle = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(CDI.class, (String)"getBeanManager", BeanManager.class, (Class[])new Class[0]), cdiResultHandle, new ResultHandle[0]);
                ResultHandle instanceResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(BeanManager.class, (String)"createInstance", Instance.class, (Class[])new Class[0]), beanManagerResultHandle, new ResultHandle[0]);
                ResultHandle kieRuntimeBuilderClass = methodCreator.loadClass(KieRuntimeBuilder.class);
                ResultHandle kieRuntimeBuilderInstanceResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Instance.class, (String)"select", Instance.class, (Class[])new Class[]{Class.class, Annotation[].class}), instanceResultHandle, new ResultHandle[]{kieRuntimeBuilderClass, methodCreator.newArray(Annotation.class, 0)});
                ResultHandle kieRuntimeBuilder = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]), kieRuntimeBuilderInstanceResultHandle, new ResultHandle[0]);
                ResultHandle kieBaseExtractor = methodCreator.newInstance(MethodDescriptor.ofConstructor(KieBaseExtractor.class, (Class[])new Class[]{KieRuntimeBuilder.class}), new ResultHandle[]{kieRuntimeBuilder});
                methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ScoreDirectorFactoryConfig.class, (String)"setKieBaseExtractor", Void.TYPE, (Class[])new Class[]{KieBaseExtractor.class}), methodCreator.getMethodParam(0), new ResultHandle[]{kieBaseExtractor});
            } else {
                methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(OptaPlannerDroolsInitializer.class, (String)"setup", Void.TYPE, (Class[])new Class[]{ScoreDirectorFactoryConfig.class}));
            }
            methodCreator.returnValue(null);
        }
        return generatedClassName;
    }

    public static RuntimeValue<OptaPlannerDroolsInitializer> getDroolsInitializer(RecorderContext recorderContext) {
        return recorderContext.newInstance(DROOLS_INITIALIZER_CLASS_NAME);
    }

    private static class OptaPlannerMethodEnhancingClassVisitor
    extends ClassVisitor {
        private final MethodInfo methodInfo;
        private final Class<?> clazz;
        private final String returnTypeDescriptor;
        private final Optional<MethodDescriptor> maybeSetter;
        private final String name;

        public OptaPlannerMethodEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, MethodInfo methodInfo, String name, Optional<MethodDescriptor> maybeSetter) {
            super(589824, outputClassVisitor);
            this.methodInfo = methodInfo;
            this.name = name;
            this.maybeSetter = maybeSetter;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.returnTypeDescriptor = DescriptorUtils.typeToString((org.jboss.jandex.Type)methodInfo.returnType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            if (this.maybeSetter.isPresent()) {
                this.addSetter(this.cv);
            }
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.returnTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, Type.getInternalName(this.clazz), this.methodInfo.name(), "()" + this.returnTypeDescriptor, false);
            mv.visitInsn(Type.getType((String)this.returnTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }

        private void addSetter(ClassVisitor classWriter) {
            if (!this.maybeSetter.isPresent()) {
                return;
            }
            MethodDescriptor setter = this.maybeSetter.get();
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, setter.getDescriptor(), null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, Type.getInternalName(this.clazz), setter.getName(), setter.getDescriptor(), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
    }

    private static class OptaPlannerFieldEnhancingClassVisitor
    extends ClassVisitor {
        private final Field fieldInfo;
        private final Class<?> clazz;
        private final String fieldTypeDescriptor;

        public OptaPlannerFieldEnhancingClassVisitor(Class<?> classInfo, ClassVisitor outputClassVisitor, Field fieldInfo) {
            super(589824, outputClassVisitor);
            this.fieldInfo = fieldInfo;
            this.clazz = classInfo;
            this.fieldTypeDescriptor = Type.getDescriptor(fieldInfo.getType());
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            this.addSetter(this.cv);
        }

        private void addSetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + this.fieldTypeDescriptor + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(Type.getType((String)this.fieldTypeDescriptor).getOpcode(21), 1);
            mv.visitFieldInsn(181, Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.fieldTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(Type.getType((String)this.fieldTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }
    }
}

