/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.gizmo.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.optaplanner.quarkus.gizmo.annotations.AllOptaPlannerAnnotationEnum;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableAnnotations;

public class QuarkusRecordableAnnotatedElement
implements AnnotatedElement {
    public List<Annotation> annotationList;

    public QuarkusRecordableAnnotatedElement() {
    }

    public QuarkusRecordableAnnotatedElement(TypeVariable typeVariable, IndexView indexView) {
        this.annotationList = QuarkusRecordableAnnotatedElement.getAnnotationListFromAnnotationInstanceList(typeVariable.annotations(), indexView);
    }

    public QuarkusRecordableAnnotatedElement(UnresolvedTypeVariable typeVariable, IndexView indexView) {
        this.annotationList = QuarkusRecordableAnnotatedElement.getAnnotationListFromAnnotationInstanceList(typeVariable.annotations(), indexView);
    }

    public QuarkusRecordableAnnotatedElement(FieldInfo fieldInfo, IndexView indexView) {
        this.annotationList = QuarkusRecordableAnnotatedElement.getAnnotationListFromAnnotationInstanceList(fieldInfo.annotations(), indexView);
    }

    public QuarkusRecordableAnnotatedElement(MethodInfo methodInfo, IndexView indexView) {
        this.annotationList = QuarkusRecordableAnnotatedElement.getAnnotationListFromAnnotationInstanceList(methodInfo.annotations(), indexView);
    }

    private static List<Annotation> getAnnotationListFromAnnotationInstanceList(List<AnnotationInstance> annotationInstanceList, IndexView indexView) {
        return annotationInstanceList.stream().filter(ann -> AllOptaPlannerAnnotationEnum.isOptaPlannerAnnotation(ann.name().toString())).map(m -> QuarkusRecordableAnnotations.getQuarkusRecorderFriendlyAnnotation(m, indexView)).collect(Collectors.toList());
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            return null;
        }
        String targetClassName = annotationClass.getName();
        return (T)((Annotation)this.getAnnotationList().stream().filter(annotation -> annotation.annotationType().getName().equals(targetClassName)).findFirst().orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getAnnotationList().toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public List<Annotation> getAnnotationList() {
        return this.annotationList;
    }

    public void setAnnotationList(List<Annotation> annotationList) {
        this.annotationList = annotationList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuarkusRecordableAnnotatedElement that = (QuarkusRecordableAnnotatedElement)o;
        return this.annotationList.equals(that.annotationList);
    }

    public int hashCode() {
        return Objects.hash(this.annotationList);
    }
}

