/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.common.AbstractConstraint;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.test.api.score.stream.SingleConstraintAssertion;

public final class DefaultSingleConstraintAssertion<Solution_>
implements SingleConstraintAssertion {
    private final ConstraintStreamScoreDirectorFactory<Solution_> scoreDirectorFactory;
    private final Map<String, ConstraintMatchTotal> constraintMatchTotalMap;

    protected DefaultSingleConstraintAssertion(ConstraintStreamScoreDirectorFactory<Solution_> scoreDirectorFactory, Map<String, ConstraintMatchTotal> constraintMatchTotalMap) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.constraintMatchTotalMap = constraintMatchTotalMap;
    }

    @Override
    public void penalizesBy(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    private void validateMatchWeighTotal(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The matchWeightTotal (" + matchWeightTotal + ") must be positive.");
        }
    }

    private void assertImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        boolean sameMatchWeighTotal;
        Number impact = this.deduceImpact();
        AbstractConstraint constraint = (AbstractConstraint)this.scoreDirectorFactory.getConstraints()[0];
        boolean bl = sameMatchWeighTotal = matchWeightTotal.equals(impact) || matchWeightTotal instanceof Integer && Long.valueOf(matchWeightTotal.longValue()).equals(impact);
        if (scoreImpactType == constraint.getScoreImpactType() && sameMatchWeighTotal) {
            return;
        }
        String constraintId = constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, matchWeightTotal, constraint.getScoreImpactType(), impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private Number deduceImpact() {
        ScoreDefinition scoreDefinition = this.scoreDirectorFactory.getScoreDefinition();
        Score zeroScore = scoreDefinition.getZeroScore();
        Number zero = zeroScore.toLevelNumbers()[0];
        if (this.constraintMatchTotalMap.isEmpty()) {
            return zero;
        }
        Score totalMatchWeightedScore = this.constraintMatchTotalMap.values().stream().map(matchScore -> scoreDefinition.divideBySanitizedDivisor(matchScore.getScore(), matchScore.getConstraintWeight())).reduce(zeroScore, Score::add);
        List matchWeightsFound = Arrays.stream(totalMatchWeightedScore.toLevelNumbers()).distinct().filter(matchWeight -> !Objects.equals(matchWeight, zero)).collect(Collectors.toList());
        if (matchWeightsFound.isEmpty()) {
            return 0;
        }
        if (matchWeightsFound.size() != 1) {
            throw new IllegalStateException("Impossible state: expecting at most one match weight, but got matchWeightsFound (" + matchWeightsFound + ") instead.");
        }
        return (Number)matchWeightsFound.get(0);
    }

    private String buildAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s (%s)%n%18s: %s (%s)";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(expectedImpactType);
        String actualImpactLabel = "Actual " + this.getImpactTypeLabel(actualImpactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedImpact, expectedImpact.getClass(), actualImpactLabel, actualImpact, actualImpact.getClass());
    }

    private String getImpactTypeLabel(ScoreImpactType scoreImpactType) {
        if (scoreImpactType == ScoreImpactType.PENALTY) {
            return "penalty";
        }
        if (scoreImpactType == ScoreImpactType.REWARD) {
            return "reward";
        }
        return "impact";
    }
}

