/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirector;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.test.api.score.stream.MultiConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultMultiConstraintAssertion;

public final class DefaultMultiConstraintVerification<Solution_>
implements MultiConstraintVerification<Solution_> {
    private final ConstraintStreamScoreDirectorFactory<Solution_> scoreDirectorFactory;
    private final ConstraintProvider constraintProvider;

    protected DefaultMultiConstraintVerification(ConstraintStreamScoreDirectorFactory<Solution_> scoreDirectorFactory, ConstraintProvider constraintProvider) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.constraintProvider = constraintProvider;
    }

    @Override
    public final DefaultMultiConstraintAssertion given(Object ... facts) {
        try (ConstraintSession constraintSession = this.scoreDirectorFactory.newConstraintStreamingSession(true, null);){
            Arrays.stream(facts).forEach(arg_0 -> ((ConstraintSession)constraintSession).insert(arg_0));
            Score score = constraintSession.calculateScore(0);
            DefaultMultiConstraintAssertion defaultMultiConstraintAssertion = new DefaultMultiConstraintAssertion(this.constraintProvider, score);
            return defaultMultiConstraintAssertion;
        }
    }

    @Override
    public final DefaultMultiConstraintAssertion givenSolution(Solution_ solution) {
        try (ConstraintStreamScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            Score score = scoreDirector.calculateScore();
            DefaultMultiConstraintAssertion defaultMultiConstraintAssertion = new DefaultMultiConstraintAssertion(this.constraintProvider, score);
            return defaultMultiConstraintAssertion;
        }
    }
}

