/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.shared.validation.SaveValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeDefinedManuallyMessage;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ScoreHolderGlobalSaveValidator
implements SaveValidator<GlobalsModel> {
    @Inject
    private MetadataService metadataService;

    public Collection<ValidationMessage> validate(Path path, GlobalsModel content) {
        boolean containsScoreHolderGlobal;
        Metadata metadata = this.metadataService.getMetadata(path);
        if (content != null && !metadata.isGenerated() && (containsScoreHolderGlobal = content.getGlobals().stream().anyMatch(g -> "scoreHolder".equals(g.getAlias())))) {
            return Arrays.asList(new ScoreHolderGlobalToBeDefinedManuallyMessage(Level.ERROR));
        }
        return Collections.emptyList();
    }

    public boolean accept(Path path) {
        return path.getFileName().endsWith(".gdrl");
    }
}

