/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.shared.validation.DeleteValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalFileToBeRemovedMessage;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ScoreHolderGlobalDeleteValidator
implements DeleteValidator<GlobalsModel> {
    private MetadataService metadataService;

    public ScoreHolderGlobalDeleteValidator() {
    }

    @Inject
    public ScoreHolderGlobalDeleteValidator(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public Collection<ValidationMessage> validate(Path path, GlobalsModel content) {
        return this.validate(path);
    }

    public Collection<ValidationMessage> validate(Path path) {
        Metadata metadata = this.metadataService.getMetadata(path);
        if (metadata.isGenerated()) {
            return Arrays.asList(new ScoreHolderGlobalFileToBeRemovedMessage(Level.ERROR));
        }
        return Collections.emptyList();
    }

    public boolean accept(Path path) {
        return path.getFileName().endsWith(".gdrl");
    }
}

