/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.shared.validation.DeleteValidator;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.ScoreHolderUtils;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeRemovedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeNotRecognizedMessage;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@ApplicationScoped
public class PlanningSolutionScoreHolderDeleteValidator
implements DeleteValidator<DataObject> {
    private DataModelerService dataModelerService;
    private IOService ioService;
    private ScoreHolderUtils scoreHolderUtils;
    private AssetsUsageService assetsUsageService;

    @Inject
    public PlanningSolutionScoreHolderDeleteValidator(DataModelerService dataModelerService, @Named(value="ioStrategy") IOService ioService, ScoreHolderUtils scoreHolderUtils, AssetsUsageService assetsUsageService) {
        this.dataModelerService = dataModelerService;
        this.ioService = ioService;
        this.scoreHolderUtils = scoreHolderUtils;
        this.assetsUsageService = assetsUsageService;
    }

    public Collection<ValidationMessage> validate(Path dataObjectPath, DataObject dataObject) {
        return this.validatePath(dataObjectPath);
    }

    public Collection<ValidationMessage> validate(Path dataObjectPath) {
        return this.validatePath(dataObjectPath);
    }

    private Collection<ValidationMessage> validatePath(Path dataObjectPath) {
        if (dataObjectPath != null) {
            String dataObjectSource = this.ioService.readAllString(Paths.convert((Path)dataObjectPath));
            GenerationResult generationResult = this.dataModelerService.loadDataObject(dataObjectPath, dataObjectSource, dataObjectPath);
            if (generationResult.hasErrors()) {
                return Collections.emptyList();
            }
            DataObject originalDataObject = generationResult.getDataObject();
            if (originalDataObject != null && originalDataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
                String originalDataObjectScoreTypeFqn = this.scoreHolderUtils.extractScoreTypeFqn(originalDataObject);
                String originalDataObjectScoreHolderTypeFqn = this.scoreHolderUtils.getScoreHolderTypeFqn(originalDataObjectScoreTypeFqn);
                if (originalDataObjectScoreHolderTypeFqn == null) {
                    return Arrays.asList(new ScoreHolderGlobalTypeNotRecognizedMessage(Level.WARNING));
                }
                List scoreHolderGlobalUsages = this.assetsUsageService.getAssetUsages(originalDataObjectScoreHolderTypeFqn, ResourceType.JAVA, dataObjectPath);
                if (scoreHolderGlobalUsages.isEmpty()) {
                    return Collections.emptyList();
                }
                return Arrays.asList(new ScoreHolderGlobalToBeRemovedMessage(Level.WARNING));
            }
        }
        return Collections.emptyList();
    }

    public boolean accept(Path path) {
        return path.getFileName().endsWith(".java");
    }
}

