/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;

public class DataObjectFieldPickerItem
implements DataObjectFieldPickerItemView.Presenter,
IsWidget {
    private DataObjectFieldPickerItemView view;
    private DataModel dataModel;
    private ObjectPropertyPath objectPropertyPath = new ObjectPropertyPathImpl();
    private DataObject rootDataObject;
    private DataObjectFieldPicker picker;

    @Inject
    public DataObjectFieldPickerItem(DataObjectFieldPickerItemView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public void init(DataModel dataModel, DataObject rootDataObject, DataObjectFieldPicker picker) {
        this.dataModel = dataModel;
        this.rootDataObject = rootDataObject;
        this.picker = picker;
        this.initSelectFieldDropdownOptions(rootDataObject);
        this.view.addRootItem(rootDataObject);
        this.view.setOrderSelectDescendingValue(false);
    }

    private void initSelectFieldDropdownOptions(DataObject dataObject) {
        this.view.initSelectFieldDropdownOptions(dataObject.getProperties().stream().filter(p -> DataModelerUtils.isManagedProperty((ObjectProperty)p)).collect(Collectors.toList()));
    }

    @Override
    public void onFieldAdded(ObjectProperty objectProperty, boolean notify) {
        this.objectPropertyPath.appendObjectProperty(objectProperty);
        this.view.addFieldItem(objectProperty);
        if (objectProperty.isBaseType() || objectProperty.isPrimitiveType()) {
            this.view.displaySelectFieldButton(false);
        } else {
            DataObject dataObject = this.dataModel.getDataObject(objectProperty.getClassName());
            this.initSelectFieldDropdownOptions(dataObject);
            this.view.displaySelectFieldButton(true);
        }
        if (notify) {
            this.picker.objectPropertyPathChanged(false);
        }
    }

    @Override
    public void onFieldRemoved(ObjectProperty objectProperty) {
        DataObject dataObject;
        for (int i = this.objectPropertyPath.getObjectPropertyPath().size() - 1; i >= 0; --i) {
            ObjectProperty currentObjectProperty = (ObjectProperty)this.objectPropertyPath.getObjectPropertyPath().get(i);
            this.objectPropertyPath.getObjectPropertyPath().remove(i);
            this.view.removeLastFieldItem();
            if (currentObjectProperty.equals(objectProperty)) break;
        }
        if (this.objectPropertyPath.getObjectPropertyPath().isEmpty()) {
            dataObject = this.rootDataObject;
        } else {
            ObjectProperty parentObjectProperty = (ObjectProperty)this.objectPropertyPath.getObjectPropertyPath().get(this.objectPropertyPath.getObjectPropertyPath().size() - 1);
            dataObject = this.dataModel.getDataObject(parentObjectProperty.getClassName());
        }
        this.initSelectFieldDropdownOptions(dataObject);
        this.view.displaySelectFieldButton(true);
        this.picker.objectPropertyPathChanged(true);
    }

    @Override
    public void onRootLabelRemoved() {
        this.picker.onFieldPickerItemRemoved(this);
    }

    @Override
    public void onMoveFieldItemUp() {
        this.picker.onMoveFieldPickerItemUp(this);
    }

    @Override
    public void onMoveFieldItemDown() {
        this.picker.onMoveFieldPickerItemDown(this);
    }

    @Override
    public void onOrderSelectValueChange(boolean descending, boolean notify) {
        this.view.setOrderSelectDescendingValue(descending);
        this.objectPropertyPath.setDescending(descending);
        if (notify) {
            this.picker.objectPropertyPathChanged(false);
        }
    }

    @Override
    public void setFieldPickerItemIndex(int index) {
        this.view.setFieldPickerItemIndex(index);
    }

    public ObjectPropertyPath getObjectPropertyPath() {
        return this.objectPropertyPath;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

