/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMediumConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionSoftConstraintMatch;

@ApplicationScoped
public class MultiConstraintHardSoftMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addMultiConstraintMatch\\(\\s*kcontext\\s*,.+\\);");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("new\\s+\\b(int|long|BigDecimal|java\\.math\\.BigDecimal)\\b\\s*\\[\\s*\\]\\s*\\{.*\\}");

    public boolean accept(IAction iAction) {
        return iAction instanceof ActionMultiConstraintHardSoftMatch || iAction instanceof ActionMultiConstraintHardMediumSoftMatch || iAction instanceof ActionMultiConstraintBendableMatch || iAction instanceof ActionMultiConstraintBendableLongMatch || iAction instanceof ActionMultiConstraintBendableBigDecimalMatch;
    }

    public String marshal(IAction iAction) {
        if (iAction instanceof ActionMultiConstraintHardSoftMatch) {
            ActionMultiConstraintHardSoftMatch actionConstraintMatch = (ActionMultiConstraintHardSoftMatch)iAction;
            return String.format("scoreHolder.addMultiConstraintMatch(kcontext, %s, %s);", actionConstraintMatch.getActionHardConstraintMatch().getConstraintMatch(), actionConstraintMatch.getActionSoftConstraintMatch().getConstraintMatch());
        }
        if (iAction instanceof ActionMultiConstraintHardMediumSoftMatch) {
            ActionMultiConstraintHardMediumSoftMatch actionConstraintMatch = (ActionMultiConstraintHardMediumSoftMatch)iAction;
            return String.format("scoreHolder.addMultiConstraintMatch(kcontext, %s, %s, %s);", actionConstraintMatch.getActionHardConstraintMatch().getConstraintMatch(), actionConstraintMatch.getActionMediumConstraintMatch().getConstraintMatch(), actionConstraintMatch.getActionSoftConstraintMatch().getConstraintMatch());
        }
        if (iAction instanceof ActionMultiConstraintBendableMatch) {
            ActionMultiConstraintBendableMatch actionConstraintMatch = (ActionMultiConstraintBendableMatch)iAction;
            return String.format("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {%s}, new int[] {%s});", actionConstraintMatch.getActionBendableHardConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")), actionConstraintMatch.getActionBendableSoftConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")));
        }
        if (iAction instanceof ActionMultiConstraintBendableLongMatch) {
            ActionMultiConstraintBendableLongMatch actionConstraintMatch = (ActionMultiConstraintBendableLongMatch)iAction;
            return String.format("scoreHolder.addMultiConstraintMatch(kcontext, new long[] {%s}, new long[] {%s});", actionConstraintMatch.getActionBendableHardConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")), actionConstraintMatch.getActionBendableSoftConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")));
        }
        if (iAction instanceof ActionMultiConstraintBendableBigDecimalMatch) {
            ActionMultiConstraintBendableBigDecimalMatch actionConstraintMatch = (ActionMultiConstraintBendableBigDecimalMatch)iAction;
            return String.format("scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {%s}, new java.math.BigDecimal[] {%s});", actionConstraintMatch.getActionBendableHardConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")), actionConstraintMatch.getActionBendableSoftConstraintMatches().stream().map(m -> m.getConstraintMatch()).collect(Collectors.joining(", ")));
        }
        throw new IllegalArgumentException("Action " + iAction + " is not supported by this extension");
    }

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public IAction unmarshal(String iActionString) {
        List parameters = StringUtils.splitArgumentsList((CharSequence)PersistenceExtensionUtils.unwrapParenthesis(iActionString));
        if (!parameters.isEmpty() && "kcontext".equals(parameters.get(0))) {
            if (parameters.size() == 3) {
                boolean hardConstraintIsArray = false;
                String hardConstraintType = null;
                String hardConstraint = (String)parameters.get(1);
                Matcher hardConstraintMatcher = ARRAY_PATTERN.matcher(hardConstraint);
                if (hardConstraintMatcher.matches()) {
                    hardConstraintIsArray = true;
                    hardConstraintType = hardConstraintMatcher.group(1);
                }
                boolean softConstraintIsArray = false;
                String softConstraintType = null;
                String softConstraint = (String)parameters.get(2);
                Matcher softConstraintMatcher = ARRAY_PATTERN.matcher(softConstraint);
                if (softConstraintMatcher.matches()) {
                    softConstraintIsArray = true;
                    softConstraintType = softConstraintMatcher.group(1);
                }
                if (hardConstraintIsArray && softConstraintIsArray && hardConstraintType.equals(softConstraintType)) {
                    List hardConstraints = StringUtils.splitArgumentsList((CharSequence)this.unwrapCurlyBrackets(hardConstraint));
                    ArrayList<ActionBendableHardConstraintMatch> bendableHardConstraintMatches = new ArrayList<ActionBendableHardConstraintMatch>(hardConstraints.size());
                    for (int i = 0; i < hardConstraints.size(); ++i) {
                        bendableHardConstraintMatches.add(new ActionBendableHardConstraintMatch(i, PersistenceExtensionUtils.extractConstraintMatchValue((String)hardConstraints.get(i))));
                    }
                    List softConstraints = StringUtils.splitArgumentsList((CharSequence)this.unwrapCurlyBrackets(softConstraint));
                    ArrayList<ActionBendableSoftConstraintMatch> bendableSoftConstraintMatches = new ArrayList<ActionBendableSoftConstraintMatch>(softConstraints.size());
                    for (int i = 0; i < softConstraints.size(); ++i) {
                        bendableSoftConstraintMatches.add(new ActionBendableSoftConstraintMatch(i, PersistenceExtensionUtils.extractConstraintMatchValue((String)softConstraints.get(i))));
                    }
                    switch (hardConstraintType) {
                        case "int": {
                            return new ActionMultiConstraintBendableMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                        case "long": {
                            return new ActionMultiConstraintBendableLongMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                        case "BigDecimal": 
                        case "java.math.BigDecimal": {
                            return new ActionMultiConstraintBendableBigDecimalMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                    }
                } else if (!hardConstraintIsArray && !softConstraintIsArray) {
                    ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
                    ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                    return new ActionMultiConstraintHardSoftMatch(hardConstraintMatch, softConstraintMatch);
                }
            }
            if (parameters.size() == 4) {
                ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
                ActionMediumConstraintMatch mediumConstraintMatch = new ActionMediumConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(3)));
                return new ActionMultiConstraintHardMediumSoftMatch(hardConstraintMatch, mediumConstraintMatch, softConstraintMatch);
            }
        }
        FreeFormLine freeFormLine = new FreeFormLine();
        freeFormLine.setText(iActionString);
        return freeFormLine;
    }

    private String unwrapCurlyBrackets(String s) {
        int start = s.indexOf(123);
        int end = s.lastIndexOf(125);
        if (start < 0 || end < 0) {
            return s;
        }
        return s.substring(start + 1, end).trim();
    }
}

