/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionSoftConstraintMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SoftConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftConstraintMatchPersistenceExtension.class);
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addSoftConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(IAction iAction) {
        return iAction instanceof ActionSoftConstraintMatch || iAction instanceof ActionBendableSoftConstraintMatch;
    }

    public String marshal(IAction iAction) {
        if (iAction instanceof ActionSoftConstraintMatch) {
            ActionSoftConstraintMatch actionConstraintMatch = (ActionSoftConstraintMatch)iAction;
            return String.format("scoreHolder.addSoftConstraintMatch(kcontext, %s);", actionConstraintMatch.getConstraintMatch());
        }
        if (iAction instanceof ActionBendableSoftConstraintMatch) {
            ActionBendableSoftConstraintMatch actionConstraintMatch = (ActionBendableSoftConstraintMatch)iAction;
            return String.format("scoreHolder.addSoftConstraintMatch(kcontext, %s, %s);", actionConstraintMatch.getPosition(), actionConstraintMatch.getConstraintMatch());
        }
        throw new IllegalArgumentException("Action " + iAction + " is not supported by this extension");
    }

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public IAction unmarshal(String iActionString) {
        String[] parameters = PersistenceExtensionUtils.unwrapParenthesis(iActionString).split("\\s*,\\s*");
        if ("kcontext".equals(parameters[0])) {
            if (parameters.length == 2) {
                return new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue(parameters[1]));
            }
            if (parameters.length == 3) {
                try {
                    int bendableScoreLevel = Integer.parseInt(parameters[1]);
                    return new ActionBendableSoftConstraintMatch(bendableScoreLevel, PersistenceExtensionUtils.extractConstraintMatchValue(parameters[2]));
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse bendable score level parameter " + parameters[1] + " as an Integer, returning a FreeFormLine");
                }
            }
        }
        FreeFormLine freeFormLine = new FreeFormLine();
        freeFormLine.setText(iActionString);
        return freeFormLine;
    }
}

