/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.javaeditor.type.JavaResourceTypeDefinition;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.workbench.screens.guidedrule.model.BendableScoreLevelsWrapper;
import org.optaplanner.workbench.screens.guidedrule.model.ScoreInformation;
import org.optaplanner.workbench.screens.guidedrule.service.ScoreHolderService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class ScoreHolderServiceImpl
implements ScoreHolderService {
    private static final String SCORE_HOLDER_GLOBAL_FILE_SUFFIX = "ScoreHolderGlobal.gdrl";
    private KieModuleService kieModuleService;
    private IOService ioService;
    private GlobalsEditorService globalsEditorService;
    private DataModelerService dataModelerService;
    private AssetsUsageService assetsUsageService;
    private JavaResourceTypeDefinition javaResourceTypeDefinition;

    public ScoreHolderServiceImpl() {
    }

    @Inject
    public ScoreHolderServiceImpl(KieModuleService kieModuleService, @Named(value="ioStrategy") IOService ioService, GlobalsEditorService globalsEditorService, DataModelerService dataModelerService, JavaResourceTypeDefinition javaResourceTypeDefinition, AssetsUsageService assetsUsageService) {
        this.kieModuleService = kieModuleService;
        this.ioService = ioService;
        this.globalsEditorService = globalsEditorService;
        this.dataModelerService = dataModelerService;
        this.javaResourceTypeDefinition = javaResourceTypeDefinition;
        this.assetsUsageService = assetsUsageService;
    }

    public ScoreInformation getProjectScoreInformation(org.uberfire.backend.vfs.Path projectPath) {
        List classUsages = this.assetsUsageService.getAssetUsages(PlanningSolution.class.getName(), ResourceType.JAVA, projectPath);
        return new ScoreInformation(this.extractProjectScoreTypeFqns(classUsages), this.getBendableScoreLevelsSize(classUsages));
    }

    private Collection<String> extractProjectScoreTypeFqns(List<org.uberfire.backend.vfs.Path> classUsages) {
        return classUsages.stream().filter(arg_0 -> ((JavaResourceTypeDefinition)this.javaResourceTypeDefinition).accept(arg_0)).flatMap(p -> this.extractSolutionScoreTypeFqns((org.uberfire.backend.vfs.Path)p).stream()).collect(Collectors.toList());
    }

    private Collection<BendableScoreLevelsWrapper> getBendableScoreLevelsSize(List<org.uberfire.backend.vfs.Path> classUsages) {
        return classUsages.stream().filter(arg_0 -> ((JavaResourceTypeDefinition)this.javaResourceTypeDefinition).accept(arg_0)).map(p -> this.extractSolutionBendableScoreLevelsSize((org.uberfire.backend.vfs.Path)p)).collect(Collectors.toList());
    }

    private Collection<String> extractSolutionScoreTypeFqns(org.uberfire.backend.vfs.Path solutionObjectPath) {
        String sourceSolutionFileName;
        Path source = Paths.convert((org.uberfire.backend.vfs.Path)this.kieModuleService.resolvePackage(solutionObjectPath).getPackageMainResourcesPath());
        Path sourcePackage = Files.isDirectory((Path)source, (LinkOption[])new LinkOption[0]) ? source : source.getParent();
        Path sourceScoreHolderGlobalPath = sourcePackage.resolve((sourceSolutionFileName = solutionObjectPath.getFileName().substring(0, solutionObjectPath.getFileName().indexOf("."))) + SCORE_HOLDER_GLOBAL_FILE_SUFFIX);
        boolean scoreHolderGlobalFileExists = this.ioService.exists(sourceScoreHolderGlobalPath);
        if (scoreHolderGlobalFileExists) {
            GlobalsModel globalsModel = (GlobalsModel)this.globalsEditorService.load(Paths.convert((Path)sourceScoreHolderGlobalPath));
            return globalsModel.getGlobals().stream().filter(global -> "scoreHolder".equals(global.getAlias())).map(Global::getClassName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public BendableScoreLevelsWrapper extractSolutionBendableScoreLevelsSize(org.uberfire.backend.vfs.Path solutionPath) {
        Annotation annotation;
        DataObject dataObject;
        ObjectProperty scoreObjectProperty;
        String solutionString = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)solutionPath));
        GenerationResult generationResult = this.dataModelerService.loadDataObject(solutionPath, solutionString, solutionPath);
        if (!generationResult.hasErrors() && (scoreObjectProperty = (dataObject = generationResult.getDataObject()).getProperty("score")) != null && this.isBendableScore(scoreObjectProperty.getClassName()) && (annotation = scoreObjectProperty.getAnnotation(PlanningScore.class.getName())) != null) {
            Object hardLevelsSize = annotation.getValue("bendableHardLevelsSize");
            Object softLevelsSize = annotation.getValue("bendableSoftLevelsSize");
            return new BendableScoreLevelsWrapper(hardLevelsSize == null ? 0 : (Integer)hardLevelsSize, softLevelsSize == null ? 0 : (Integer)softLevelsSize);
        }
        return new BendableScoreLevelsWrapper();
    }

    private boolean isBendableScore(String planningSolutionScoreType) {
        return BendableScore.class.getName().equals(planningSolutionScoreType) || BendableLongScore.class.getName().equals(planningSolutionScoreType) || BendableBigDecimalScore.class.getName().equals(planningSolutionScoreType);
    }
}

