/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ScoreHolderGlobalAware;
import org.optaplanner.workbench.screens.guidedrule.model.AbstractActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.BendableScoreLevelsWrapper;
import org.optaplanner.workbench.screens.guidedrule.model.ScoreInformation;
import org.optaplanner.workbench.screens.guidedrule.service.ScoreHolderService;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class ActionPluginClientService {
    static final String SCORE_INFORMATION = ActionPluginClientService.class.getName() + ".score.information";
    private Caller<ScoreHolderService> scoreHolderService;
    private TranslationService translationService;

    @Inject
    public ActionPluginClientService(Caller<ScoreHolderService> scoreHolderService, TranslationService translationService) {
        this.scoreHolderService = scoreHolderService;
        this.translationService = translationService;
    }

    public void invokeScoreInformationCachedOperation(RuleModeller ruleModeller, Consumer<ScoreInformation> scoreInformationConsumer) {
        Object scoreInformationObject = ruleModeller.getServiceInvocationCache().get(SCORE_INFORMATION);
        if (!(scoreInformationObject instanceof ScoreInformation)) {
            ((ScoreHolderService)this.scoreHolderService.call(scoreInformation -> {
                ruleModeller.getServiceInvocationCache().put(SCORE_INFORMATION, scoreInformation);
                scoreInformationConsumer.accept((ScoreInformation)scoreInformation);
            })).getProjectScoreInformation(ruleModeller.getPath());
        } else {
            ScoreInformation scoreInformation2 = (ScoreInformation)ruleModeller.getServiceInvocationCache().get(SCORE_INFORMATION);
            scoreInformationConsumer.accept(scoreInformation2);
        }
    }

    public void initScoreHolderAwarePlugin(RuleModeller ruleModeller, ScoreHolderGlobalAware scoreHolderGlobalAware, Collection supportedScoreHolderTypes) {
        this.invokeScoreInformationCachedOperation(ruleModeller, scoreInformation -> {
            Collection scoreHolderFqns = scoreInformation.getScoreHolderFqnTypeFqns();
            if (scoreHolderFqns.isEmpty()) {
                scoreHolderGlobalAware.scoreHolderGlobalIssueDetected(this.translationService.getTranslation("ActionPluginClientService.ScoreHolderGlobalNotFound"));
            } else if (scoreHolderFqns.size() > 1) {
                scoreHolderGlobalAware.scoreHolderGlobalIssueDetected(this.translationService.getTranslation(this.translationService.getTranslation("ActionPluginClientService.MultipleScoreHolderGlobals")));
            } else if (scoreHolderFqns.size() == 1) {
                if (!supportedScoreHolderTypes.containsAll(scoreHolderFqns)) {
                    scoreHolderGlobalAware.scoreHolderGlobalIssueDetected(this.translationService.getTranslation("ActionPluginClientService.ScoreTypeNotSupported"));
                } else {
                    scoreHolderGlobalAware.scoreHolderGlobalLoadedCorrectly();
                }
            }
        });
    }

    public void addPluginToActionList(RuleModeller ruleModeller, Command addCommand, Collection supportedScoreHolderTypes) {
        this.invokeScoreInformationCachedOperation(ruleModeller, scoreInformation -> {
            Collection scoreHolderFqns = scoreInformation.getScoreHolderFqnTypeFqns();
            if (scoreHolderFqns.size() == 1 && supportedScoreHolderTypes.containsAll(scoreHolderFqns)) {
                addCommand.execute();
            }
        });
    }

    public void initBendableScoreLevels(RuleModeller ruleModeller, AbstractActionMultiConstraintBendableMatch constraintMatch) {
        this.invokeScoreInformationCachedOperation(ruleModeller, scoreInformation -> {
            Collection scoreLevels = scoreInformation.getBendableScoreLevelsWrappers();
            if (scoreLevels.size() == 1) {
                BendableScoreLevelsWrapper scoreLevelsWrapper = (BendableScoreLevelsWrapper)scoreLevels.iterator().next();
                ArrayList<ActionBendableHardConstraintMatch> hardConstraints = new ArrayList<ActionBendableHardConstraintMatch>(scoreLevelsWrapper.getHardScoreLevels());
                for (int i = 0; i < scoreLevelsWrapper.getHardScoreLevels(); ++i) {
                    hardConstraints.add(new ActionBendableHardConstraintMatch(i, null));
                }
                constraintMatch.setActionBendableHardConstraintMatches(hardConstraints);
                ArrayList<ActionBendableSoftConstraintMatch> softConstraints = new ArrayList<ActionBendableSoftConstraintMatch>(scoreLevelsWrapper.getSoftScoreLevels());
                for (int i = 0; i < scoreLevelsWrapper.getSoftScoreLevels(); ++i) {
                    softConstraints.add(new ActionBendableSoftConstraintMatch(i, null));
                }
                constraintMatch.setActionBendableSoftConstraintMatches(softConstraints);
            }
        });
    }
}

