/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.workbench.screens.solver.backend.server.ConfigPersistence;

public class SolverValidator {
    @Inject
    private ConfigPersistence configPersistence;

    public List<ValidationMessage> validate(String xml) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        try {
            SolverConfig solverConfig = this.configPersistence.toSolverConfig(xml);
            solverConfig.buildSolver(new SolverConfigContext());
        }
        catch (Exception e) {
            validationMessages.add(this.make(e));
        }
        return validationMessages;
    }

    private ValidationMessage make(Exception e) {
        ValidationMessage message = new ValidationMessage();
        message.setId(0L);
        message.setLevel(Level.ERROR);
        message.setText(e.getMessage());
        return message;
    }
}

