/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.validation.asset.NoProjectException;
import org.kie.workbench.common.services.backend.validation.asset.Validator;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.optaplanner.core.api.solver.SolverFactory;
import org.uberfire.backend.vfs.Path;

public class SolverValidator {
    private static final Set<String> SMOKE_TEST_SUPPORTED_PROJECTS = new HashSet<String>();
    private KieProjectService projectService;
    @Inject
    private LRUBuilderCache builderCache;
    @Inject
    private BuildService buildService;

    public SolverValidator() {
    }

    @Inject
    public SolverValidator(KieProjectService projectService) {
        this.projectService = projectService;
    }

    public List<ValidationMessage> validate(Path resourcePath, String content) {
        try {
            org.kie.workbench.common.services.shared.project.KieProject kieProject = (org.kie.workbench.common.services.shared.project.KieProject)this.projectService.resolveProject(resourcePath);
            List validationMessages = this.validator().validate(resourcePath, content);
            if (validationMessages.isEmpty()) {
                return this.buildSolver(resourcePath, kieProject);
            }
            return validationMessages;
        }
        catch (NoProjectException e) {
            return new ArrayList<ValidationMessage>();
        }
    }

    private ByteArrayInputStream inputStream(String content) {
        return new ByteArrayInputStream(content.getBytes(Charsets.UTF_8));
    }

    private List<ValidationMessage> buildSolver(Path resourcePath, org.kie.workbench.common.services.shared.project.KieProject kieProject) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        ValidationMessage validationMessage = this.createSolverFactory(resourcePath, kieProject);
        if (validationMessage != null) {
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    private Validator validator() throws NoProjectException {
        return new Validator((ProjectService)this.projectService, this.buildService){

            protected boolean isValidatPath(Path path, ValidationMessage message) {
                return true;
            }
        };
    }

    private ValidationMessage createSolverFactory(Path resourcePath, org.kie.workbench.common.services.shared.project.KieProject kieWorkbenchProject) {
        Builder builder = this.builderCache.assertBuilder((Project)kieWorkbenchProject);
        InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
        KieModuleKieProject kieProject = new KieModuleKieProject(kieModule, null);
        KieContainerImpl kieContainer = new KieContainerImpl((KieProject)kieProject, KieServices.Factory.get().getRepository());
        try {
            String solverConfigResource = this.getSolverConfigResource(resourcePath, kieWorkbenchProject);
            SolverFactory.createFromKieContainerXmlResource((KieContainer)kieContainer, (String)solverConfigResource).buildSolver();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.make(e, resourcePath);
        }
        return null;
    }

    private String getSolverConfigResource(Path resourcePath, org.kie.workbench.common.services.shared.project.KieProject kieWorkbenchProject) {
        return resourcePath.toURI().substring(kieWorkbenchProject.getRootPath().toURI().length() + "/src/main/resources/".length());
    }

    private ValidationMessage make(Exception e, Path resourcePath) {
        ValidationMessage message = new ValidationMessage();
        message.setId(0L);
        message.setLevel(Level.ERROR);
        message.setPath(resourcePath);
        message.setText(e.getMessage());
        return message;
    }

    static {
        SMOKE_TEST_SUPPORTED_PROJECTS.add("optacloud");
    }
}

