/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorView;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.model.SolverModelContent;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="OptaPlannerSolverEditor", supportedTypes={SolverResourceType.class}, priority=10)
public class SolverEditorPresenter
extends KieEditor {
    @Inject
    private Caller<SolverEditorService> solverService;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private SolverResourceType solverResourceType;
    private SolverEditorView view;

    @Inject
    public SolverEditorPresenter(SolverEditorView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.solverResourceType);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((SolverEditorService)this.solverService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<SolverModelContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<SolverModelContent>(){

            public void callback(SolverModelContent content) {
                if (SolverEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                SolverEditorPresenter.this.resetEditorPages(content.getOverview());
                SolverEditorPresenter.this.addSourcePage();
                String config = content.getConfig();
                SolverEditorPresenter.this.view.setContent(config);
                SolverEditorPresenter.this.view.hideBusyIndicator();
                SolverEditorPresenter.this.createOriginalHash(SolverEditorPresenter.this.view.getContent());
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((SolverEditorService)SolverEditorPresenter.this.solverService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            SolverEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            ValidationPopup.showMessages(results);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback())).validate((Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)SolverEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save(String commitMessage) {
        ((SolverEditorService)this.solverService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    public void onSourceTabSelected() {
        this.updateSource(this.view.getContent());
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

