/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.inject.Inject;
import org.optaplanner.workbench.screens.solver.client.editor.ScoreDirectorFactoryFormView;
import org.optaplanner.workbench.screens.solver.model.ScoreDefinitionTypeModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;

public class ScoreDirectorFactoryForm
implements IsWidget {
    private ScoreDirectorFactoryFormView view;
    private ScoreDirectorFactoryConfigModel model;

    @Inject
    public ScoreDirectorFactoryForm(ScoreDirectorFactoryFormView view) {
        this.view = view;
        view.setPresenter(this);
        for (ScoreDefinitionTypeModel type : ScoreDefinitionTypeModel.values()) {
            view.addScoreDefinitionType(type);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void onScoreDefinitionTypeSelected(String typeName) {
        for (ScoreDefinitionTypeModel type : ScoreDefinitionTypeModel.values()) {
            if (!type.name().equals(typeName)) continue;
            this.model.setScoreDefinitionType(type);
            break;
        }
    }

    public void setModel(ScoreDirectorFactoryConfigModel model) {
        this.model = model;
        if (model.getScoreDefinitionType() == null) {
            model.setScoreDefinitionType(ScoreDefinitionTypeModel.HARD_SOFT);
        }
        this.view.setSelectedScoreDefinitionType(model.getScoreDefinitionType());
        if (model.getScoreDrlList() == null || model.getScoreDrlList().isEmpty()) {
            this.view.setScoreDrl("");
        } else {
            this.view.setScoreDrl((String)model.getScoreDrlList().get(0));
        }
    }

    public void onFileNameChange(String fileName) {
        if (this.model.getScoreDrlList() == null) {
            this.model.setScoreDrlList(new ArrayList());
        }
        if (this.model.getScoreDrlList().isEmpty()) {
            this.model.getScoreDrlList().add(fileName);
        } else {
            this.model.getScoreDrlList().set(0, fileName);
        }
    }
}

