/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigFormView;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;

@Dependent
public class TerminationConfigForm
implements IsWidget {
    private TerminationConfigModel model;
    private TerminationConfigFormView view;

    @Inject
    public TerminationConfigForm(TerminationConfigFormView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setModel(TerminationConfigModel terminationConfigModel) {
        this.model = terminationConfigModel;
        this.setValuesIntoView();
    }

    private void setValuesIntoView() {
        if (this.isSpentLimitSet()) {
            this.view.showSpentLimit(true);
            this.view.setDaysSpentLimit(this.model.getDaysSpentLimit());
            this.view.setHoursSpentLimit(this.model.getHoursSpentLimit());
            this.view.setMinutesSpentLimit(this.model.getMinutesSpentLimit());
            this.view.setSecondsSpentLimit(this.model.getSecondsSpentLimit());
        } else {
            this.view.showSpentLimit(false);
        }
        if (this.isUnimprovedSpentLimitSet()) {
            this.view.showUnimprovedSpentLimit(true);
            this.view.setUnimprovedDaysSpentLimit(this.model.getUnimprovedDaysSpentLimit());
            this.view.setUnimprovedHoursSpentLimit(this.model.getUnimprovedHoursSpentLimit());
            this.view.setUnimprovedMinutesSpentLimit(this.model.getUnimprovedMinutesSpentLimit());
            this.view.setUnimprovedSecondsSpentLimit(this.model.getUnimprovedSecondsSpentLimit());
        } else {
            this.view.showUnimprovedSpentLimit(false);
        }
    }

    private boolean isSpentLimitSet() {
        return this.model.getHoursSpentLimit() != null || this.model.getMinutesSpentLimit() != null || this.model.getSecondsSpentLimit() != null;
    }

    private boolean isUnimprovedSpentLimitSet() {
        return this.model.getUnimprovedHoursSpentLimit() != null || this.model.getUnimprovedMinutesSpentLimit() != null || this.model.getUnimprovedSecondsSpentLimit() != null;
    }

    public void onHoursSpentLimitChange(Long hours) {
        this.model.setHoursSpentLimit(hours);
    }

    public void onMinutesSpentLimitChange(Long minutes) {
        this.model.setMinutesSpentLimit(minutes);
    }

    public void onSecondsSpentLimitChange(Long seconds) {
        this.model.setSecondsSpentLimit(seconds);
    }

    public void onUnimprovedHoursSpentLimit(Long hours) {
        this.model.setUnimprovedHoursSpentLimit(hours);
    }

    public void onDaysSpentLimitChange(Long value) {
        this.model.setDaysSpentLimit(value);
    }

    public void onUnimprovedDaysSpentLimitChange(Long value) {
        this.model.setUnimprovedDaysSpentLimit(value);
    }

    public void onUnimprovedMinutesSpentLimit(Long minutes) {
        this.model.setUnimprovedMinutesSpentLimit(minutes);
    }

    public void onUnimprovedSecondsSpentLimit(Long seconds) {
        this.model.setUnimprovedSecondsSpentLimit(seconds);
    }

    public void onUseSpentLimitChange(Boolean value) {
        if (value.booleanValue()) {
            this.model.setDaysSpentLimit(Long.valueOf(0L));
            this.model.setHoursSpentLimit(Long.valueOf(0L));
            this.model.setMinutesSpentLimit(Long.valueOf(0L));
            this.model.setSecondsSpentLimit(Long.valueOf(0L));
        } else {
            this.model.setDaysSpentLimit(null);
            this.model.setHoursSpentLimit(null);
            this.model.setMinutesSpentLimit(null);
            this.model.setSecondsSpentLimit(null);
        }
        this.setValuesIntoView();
    }

    public void onUseUnimprovedSpentLimitChange(Boolean value) {
        if (value.booleanValue()) {
            this.model.setUnimprovedDaysSpentLimit(Long.valueOf(0L));
            this.model.setUnimprovedHoursSpentLimit(Long.valueOf(0L));
            this.model.setUnimprovedMinutesSpentLimit(Long.valueOf(0L));
            this.model.setUnimprovedSecondsSpentLimit(Long.valueOf(0L));
        } else {
            this.model.setUnimprovedDaysSpentLimit(null);
            this.model.setUnimprovedHoursSpentLimit(null);
            this.model.setUnimprovedMinutesSpentLimit(null);
            this.model.setUnimprovedSecondsSpentLimit(null);
        }
        this.setValuesIntoView();
    }
}

