/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.optaplanner.workbench.screens.solver.client.editor.ScoreDirectorFactoryFormView;
import org.optaplanner.workbench.screens.solver.model.ScoreDefinitionTypeModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.uberfire.backend.vfs.Path;

public class ScoreDirectorFactoryForm
implements IsWidget {
    private ScoreDirectorFactoryFormView view;
    private ScoreDirectorFactoryConfigModel model;

    @Inject
    public ScoreDirectorFactoryForm(ScoreDirectorFactoryFormView view) {
        this.view = view;
        view.setPresenter(this);
        for (ScoreDefinitionTypeModel type : ScoreDefinitionTypeModel.values()) {
            view.addScoreDefinitionType(type);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void onScoreDefinitionTypeSelected(String typeName) {
        for (ScoreDefinitionTypeModel type : ScoreDefinitionTypeModel.values()) {
            if (!type.name().equals(typeName)) continue;
            this.model.setScoreDefinitionType(type);
            break;
        }
    }

    public void setModel(ScoreDirectorFactoryConfigModel model, Path path) {
        this.model = model;
        if (model.getScoreDefinitionType() == null) {
            model.setScoreDefinitionType(ScoreDefinitionTypeModel.HARD_SOFT);
        }
        this.view.setSelectedScoreDefinitionType(model.getScoreDefinitionType());
        this.view.setKSession(model.getKSessionName(), path);
    }

    public void onKSessionNameChange(String ksessionName) {
        this.model.setKSessionName(ksessionName);
    }
}

