/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.XMLViewer;
import org.optaplanner.workbench.screens.solver.client.resources.i18n.SolverEditorConstants;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverModelContent;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.views.pfly.multipage.PageImpl;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="OptaPlannerSolverEditor", supportedTypes={SolverResourceType.class}, priority=10)
public class SolverEditorPresenter
extends KieEditor {
    private Caller<SolverEditorService> solverService;
    private Event<NotificationEvent> notification;
    private SolverResourceType solverResourceType;
    private XMLViewer xmlViewer;
    private SolverEditorView view;
    private SolverConfigModel model;

    @Inject
    public SolverEditorPresenter(SolverEditorView view, SolverResourceType solverResourceType, XMLViewer xmlViewer, Event<NotificationEvent> notification, Caller<SolverEditorService> solverService) {
        super((KieEditorView)view);
        this.xmlViewer = xmlViewer;
        this.view = view;
        this.solverResourceType = solverResourceType;
        this.notification = notification;
        this.solverService = solverService;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.solverResourceType);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((SolverEditorService)this.solverService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<SolverModelContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<SolverModelContent>(){

            public void callback(SolverModelContent content) {
                if (SolverEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                SolverEditorPresenter.this.resetEditorPages(content.getOverview());
                SolverEditorPresenter.this.addXMLSourcePage();
                SolverEditorPresenter.this.model = content.getConfig();
                SolverEditorPresenter.this.view.setTerminationConfigModel(SolverEditorPresenter.this.model.getTermination());
                SolverEditorPresenter.this.view.setScoreDirectorFactoryConfig(SolverEditorPresenter.this.model.getScoreDirectorFactoryConfig(), (Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath());
                SolverEditorPresenter.this.view.hideBusyIndicator();
                SolverEditorPresenter.this.createOriginalHash(SolverEditorPresenter.this.model);
            }
        };
    }

    private void addXMLSourcePage() {
        this.addPage((Page)new PageImpl(this.xmlViewer, SolverEditorConstants.INSTANCE.Source()){

            public void onFocus() {
                ((SolverEditorService)SolverEditorPresenter.this.solverService.call(SolverEditorPresenter.this.getToSourceRemoteCallback(), (ErrorCallback)new DefaultErrorCallback())).toSource((Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)SolverEditorPresenter.this.model);
            }
        });
    }

    private RemoteCallback<String> getToSourceRemoteCallback() {
        return new RemoteCallback<String>(){

            public void callback(String xml) {
                SolverEditorPresenter.this.xmlViewer.setContent(xml);
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((SolverEditorService)SolverEditorPresenter.this.solverService.call(SolverEditorPresenter.this.getValidateRemoteCallback(), (ErrorCallback)new DefaultErrorCallback())).validate((Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)SolverEditorPresenter.this.model);
            }
        };
    }

    private RemoteCallback<List<ValidationMessage>> getValidateRemoteCallback() {
        return new RemoteCallback<List<ValidationMessage>>(){

            public void callback(List<ValidationMessage> results) {
                if (results == null || results.isEmpty()) {
                    SolverEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                } else {
                    ValidationPopup.showMessages(results);
                }
            }
        };
    }

    protected void save(String commitMessage) {
        ((SolverEditorService)this.solverService.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, this.metadata, commitMessage);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

