/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.optaplanner.workbench.screens.solver.client.editor.HasValueChangeHandlersImpl;
import org.optaplanner.workbench.screens.solver.client.editor.SpinnerView;

@Dependent
public class Spinner
extends HasValueChangeHandlersImpl<Long>
implements IsWidget {
    private long value = 0L;
    private long max = 0L;
    private SpinnerView view;

    public Spinner() {
    }

    @Inject
    public Spinner(SpinnerView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public void setValue(Long value) {
        if (value == null) {
            value = 0L;
        }
        this.value = value;
        this.view.setValue(value);
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void onUp() {
        if (this.max != 0L && this.value >= this.max) {
            this.setValue(0L);
        } else {
            this.setValue(this.value + 1L);
        }
    }

    public void onDown() {
        if (this.max != 0L && this.value > 0L) {
            this.setValue(this.value - 1L);
        } else {
            this.setValue(this.max);
        }
    }

    public void onValueChange(String newValue) {
        try {
            long newLongValue = Long.parseLong(newValue);
            if (this.max == 0L || newLongValue > 0L && newLongValue <= this.max) {
                this.setValue(newLongValue);
            } else {
                this.view.setValue(this.value);
            }
        }
        catch (NumberFormatException e) {
            this.view.setValue(this.value);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.view.enable();
        } else {
            this.view.disable();
            this.value = 0L;
            this.view.setValue(this.value);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setText(String text) {
        this.view.setLabel(text);
    }
}

