/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class PhaseConfigFormViewImpl implements PhaseConfigFormView {

    @DataField("view")
    @Inject
    Div view;

    @DataField("addPhaseButtonGroup")
    @Inject
    Div addPhaseButtonGroup;

    @DataField("dropdownMenuList")
    DropDownMenu dropdownMenuList;

    private PhaseConfigForm presenter;

    @Inject
    public PhaseConfigFormViewImpl( final DropDownMenu dropdownMenuList ) {
        this.dropdownMenuList = dropdownMenuList;
        AnchorListItem constructionHeuristicListItem = new AnchorListItem( "Construction heuristic" );
        constructionHeuristicListItem.addClickHandler( h -> presenter.addConstructionHeuristic() );
        this.dropdownMenuList.add( constructionHeuristicListItem );
        // TODO add Local search, Exhaustive search, ...
    }

    @Override
    public HTMLElement getElement() {
        return view;
    }

    @Override
    public void setPresenter( PhaseConfigForm presenter ) {
        this.presenter = presenter;
    }

    @Override
    public void addConstructionHeuristic( HTMLElement element ) {
        view.insertBefore( element, addPhaseButtonGroup );
    }

    @Override
    public void removeConstructionHeuristic( HTMLElement element ) {
        view.removeChild( element );
    }
}
