/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicFormView;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.client.resources.i18n.SolverEditorConstantsWithLookup;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicTypeModel;
import org.uberfire.commons.data.Pair;

@Dependent
public class ConstructionHeuristicForm
implements IsElement {
    private final ConstructionHeuristicFormView view;
    private ConstructionHeuristicPhaseConfigModel model;
    private PhaseConfigForm phaseConfigForm;
    private SolverEditorConstantsWithLookup solverEditorConstantsWithLookup = (SolverEditorConstantsWithLookup)GWT.create(SolverEditorConstantsWithLookup.class);

    @Inject
    public ConstructionHeuristicForm(ConstructionHeuristicFormView view) {
        this.view = view;
        view.setPresenter(this);
        ArrayList<Pair<String, String>> constructionHeuristicTypeOptions = new ArrayList<Pair<String, String>>();
        for (ConstructionHeuristicTypeModel constructionHeuristicTypeModel : ConstructionHeuristicTypeModel.values()) {
            Pair option = new Pair((Object)this.solverEditorConstantsWithLookup.getString(constructionHeuristicTypeModel.name()), (Object)constructionHeuristicTypeModel.name());
            constructionHeuristicTypeOptions.add((Pair<String, String>)option);
        }
        view.initConstructionHeuristicTypeSelectOptions(constructionHeuristicTypeOptions);
    }

    public void setPhaseConfigForm(PhaseConfigForm phaseConfigForm) {
        this.phaseConfigForm = phaseConfigForm;
    }

    public void onConstructionHeuristicTypeSelected(String constructionHeuristicType) {
        this.model.setConstructionHeuristicType(ConstructionHeuristicTypeModel.valueOf((String)constructionHeuristicType));
    }

    public void onConstructionHeuristicRemoved() {
        this.phaseConfigForm.removeConstructionHeuristic(this);
    }

    public ConstructionHeuristicPhaseConfigModel getModel() {
        return this.model;
    }

    public void setModel(ConstructionHeuristicPhaseConfigModel model) {
        this.model = model;
        if (model.getConstructionHeuristicType() == null) {
            model.setConstructionHeuristicType(ConstructionHeuristicTypeModel.FIRST_FIT);
        }
        this.view.setSelectedConstructionHeuristicType(model.getConstructionHeuristicType().name());
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }
}

