/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicForm;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigFormView;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.PhaseConfigModel;

@Dependent
public class PhaseConfigForm
implements IsElement {
    private List<PhaseConfigModel> model;
    private List phaseFormList = new ArrayList();
    private PhaseConfigFormView view;
    private SyncBeanManager syncBeanManager;

    @Inject
    public PhaseConfigForm(PhaseConfigFormView view, SyncBeanManager syncBeanManager) {
        this.view = view;
        this.syncBeanManager = syncBeanManager;
        view.setPresenter(this);
    }

    public void addConstructionHeuristic() {
        ConstructionHeuristicPhaseConfigModel constructionHeuristicPhaseConfigModel = new ConstructionHeuristicPhaseConfigModel();
        this.model.add((PhaseConfigModel)constructionHeuristicPhaseConfigModel);
        this.addConstructionHeuristic(constructionHeuristicPhaseConfigModel);
    }

    public void addConstructionHeuristic(ConstructionHeuristicPhaseConfigModel constructionHeuristicPhaseConfigModel) {
        ConstructionHeuristicForm constructionHeuristicForm = (ConstructionHeuristicForm)this.syncBeanManager.lookupBean(ConstructionHeuristicForm.class, new Annotation[0]).newInstance();
        constructionHeuristicForm.setPhaseConfigForm(this);
        constructionHeuristicForm.setModel(constructionHeuristicPhaseConfigModel);
        this.phaseFormList.add(constructionHeuristicForm);
        this.view.addConstructionHeuristic(constructionHeuristicForm.getElement());
    }

    public void removeConstructionHeuristic(ConstructionHeuristicForm constructionHeuristicForm) {
        this.phaseFormList.remove(constructionHeuristicForm);
        this.view.removeConstructionHeuristic(constructionHeuristicForm.getElement());
        this.model.remove(constructionHeuristicForm.getModel());
    }

    public List<PhaseConfigModel> getModel() {
        return this.model;
    }

    public void setModel(List<PhaseConfigModel> model) {
        this.model = model;
        for (PhaseConfigModel phaseConfigModel : model) {
            if (!(phaseConfigModel instanceof ConstructionHeuristicPhaseConfigModel)) continue;
            this.addConstructionHeuristic((ConstructionHeuristicPhaseConfigModel)phaseConfigModel);
        }
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PreDestroy
    public void destroy() {
        for (Object phaseForm : this.phaseFormList) {
            this.syncBeanManager.destroyBean(phaseForm);
        }
    }
}

