/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.optaplanner.core.config.localsearch.LocalSearchType;
import org.optaplanner.workbench.screens.solver.client.editor.LocalSearchFormView;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.client.resources.i18n.SolverEditorLookupConstants;
import org.optaplanner.workbench.screens.solver.model.LocalSearchPhaseConfigModel;
import org.uberfire.commons.data.Pair;

@Dependent
public class LocalSearchForm
implements IsElement {
    private final LocalSearchFormView view;
    private LocalSearchPhaseConfigModel model;
    private PhaseConfigForm phaseConfigForm;
    private SolverEditorLookupConstants solverEditorLookupConstants = (SolverEditorLookupConstants)GWT.create(SolverEditorLookupConstants.class);

    @Inject
    public LocalSearchForm(LocalSearchFormView view) {
        this.view = view;
        view.setPresenter(this);
        this.initLocalSearchTypeSelectOptions();
    }

    private void initLocalSearchTypeSelectOptions() {
        ArrayList<Pair<String, String>> localSearchTypeOptions = new ArrayList<Pair<String, String>>();
        for (LocalSearchType localSearchType : LocalSearchType.values()) {
            Pair option = new Pair((Object)this.solverEditorLookupConstants.getString(localSearchType.name()), (Object)localSearchType.name());
            localSearchTypeOptions.add((Pair<String, String>)option);
        }
        this.view.initLocalSearchTypeSelectOptions(localSearchTypeOptions);
    }

    public void setPhaseConfigForm(PhaseConfigForm phaseConfigForm) {
        this.phaseConfigForm = phaseConfigForm;
    }

    public void onLocalSearchTypeSelected(String localSearchType) {
        this.model.setLocalSearchType(LocalSearchType.valueOf((String)localSearchType));
    }

    public void onLocalSearchRemoved() {
        this.phaseConfigForm.removeLocalSearch(this);
    }

    public LocalSearchPhaseConfigModel getModel() {
        return this.model;
    }

    public void setModel(LocalSearchPhaseConfigModel model) {
        this.model = model;
        if (model.getLocalSearchType() == null) {
            model.setLocalSearchType(LocalSearchType.LATE_ACCEPTANCE);
        }
        this.view.setSelectedLocalSearchType(model.getLocalSearchType().name());
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }
}

