/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.TreeItem;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigForm;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContentView;
import org.optaplanner.workbench.screens.solver.model.TerminationCompositionStyleModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigOption;

@Dependent
public class TerminationTreeItemContent
implements IsElement {
    public static final long MINUTES_SPENT_DEFAULT_VALUE = 5L;
    public static final long UNIMPROVED_MINUTES_SPENT_DEFAULT_VALUE = 5L;
    private TerminationConfigForm terminationConfigForm;
    private TreeItem treeItem;
    private TerminationConfigOption terminationConfigOption;
    private TerminationConfigModel model;
    private TerminationTreeItemContentView view;
    private TranslationService translationService;
    private Map<TerminationConfigOption, TerminationManager> terminationManagerMap = new HashMap<TerminationConfigOption, TerminationManager>();

    @Inject
    public TerminationTreeItemContent(TerminationTreeItemContentView view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
        view.setPresenter(this);
        this.initTerminationManagerMap();
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    public TerminationConfigModel getModel() {
        return this.model;
    }

    public TerminationConfigOption getTerminationConfigOption() {
        return this.terminationConfigOption;
    }

    public void removeDropDownOption(TerminationConfigOption terminationConfigOption) {
        if (terminationConfigOption != TerminationConfigOption.NESTED) {
            this.view.removeDropDownOption(terminationConfigOption);
        }
    }

    public TerminationTreeItemContentView getView() {
        return this.view;
    }

    public void setModel(TerminationConfigModel model) {
        this.model = model;
    }

    public void setTerminationConfigOption(TerminationConfigOption terminationConfigOption) {
        this.terminationConfigOption = terminationConfigOption;
        this.view.setNestedTreeItem(terminationConfigOption == TerminationConfigOption.NESTED);
        if (terminationConfigOption == TerminationConfigOption.NESTED) {
            this.view.setDropDownHelpContent(this.translationService.getTranslation("TerminationTreeItemContent.TerminationCompositionStyleHelp"));
        }
        this.setLabelStrings(terminationConfigOption);
        this.hideViewInputs(terminationConfigOption);
    }

    private void setLabelStrings(TerminationConfigOption terminationConfigOption) {
        this.getTerminationManager(terminationConfigOption).setLabelStrings();
    }

    private TerminationManager getTerminationManager(TerminationConfigOption terminationConfigOption) {
        TerminationManager terminationManager = this.terminationManagerMap.get(terminationConfigOption);
        if (terminationManager == null) {
            throw new IllegalStateException("TerminationManager for terminationConfigOption" + terminationConfigOption + " is not defined.");
        }
        return terminationManager;
    }

    private void hideViewInputs(TerminationConfigOption terminationConfigOption) {
        for (TerminationConfigOption option : this.terminationManagerMap.keySet()) {
            if (terminationConfigOption == option) continue;
            this.getTerminationManager(option).hideViewInputs();
        }
    }

    public void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
        this.view.setRoot(treeItem.getParentItem() == null);
    }

    public void onTerminationTypeSelected(String terminationType) {
        this.terminationConfigForm.addNewTerminationType(terminationType, this);
    }

    public void setTerminationConfigForm(TerminationConfigForm terminationConfigForm) {
        this.terminationConfigForm = terminationConfigForm;
    }

    public void removeTreeItem() {
        TerminationTreeItemContent parent = this.treeItem.getParentItem() == null ? this : (TerminationTreeItemContent)this.treeItem.getParentItem().getUserObject();
        this.getTerminationManager(this.terminationConfigOption).removeModelValue();
        parent.getView().addDropDownOption(this.terminationConfigOption);
        this.treeItem.remove();
        this.terminationConfigForm.displayEmptyTreeLabel(this.terminationConfigForm.getRootTreeItem().getChildCount() == 0);
        this.terminationConfigForm.destroyTerminationTreeItemContent(this);
    }

    public void onDaysSpentChange(Long value) {
        this.model.setDaysSpentLimit(value);
    }

    public void onHoursSpentChange(Long value) {
        this.model.setHoursSpentLimit(value);
    }

    public void onMinutesSpentChange(Long value) {
        this.model.setMinutesSpentLimit(value);
    }

    public void onSecondsSpentChange(Long value) {
        this.model.setSecondsSpentLimit(value);
    }

    public void onMillisecondsSpentChange(Long value) {
        this.model.setMillisecondsSpentLimit(value);
    }

    public void onUnimprovedDaysSpentChange(Long value) {
        this.model.setUnimprovedDaysSpentLimit(value);
    }

    public void onUnimprovedHoursSpentChange(Long value) {
        this.model.setUnimprovedHoursSpentLimit(value);
    }

    public void onUnimprovedMinutesSpentChange(Long value) {
        this.model.setUnimprovedMinutesSpentLimit(value);
    }

    public void onUnimprovedSecondsSpentChange(Long value) {
        this.model.setUnimprovedSecondsSpentLimit(value);
    }

    public void onUnimprovedMillisecondsSpentChange(Long value) {
        this.model.setUnimprovedMillisecondsSpentLimit(value);
    }

    public void onStepCountLimitChange(Integer value) {
        this.model.setStepCountLimit(value);
    }

    public void onUnimprovedStepCountLimitChange(Integer value) {
        this.model.setUnimprovedStepCountLimit(value);
    }

    public void onScoreCalculationLimitChange(Long value) {
        this.model.setScoreCalculationCountLimit(value);
    }

    public void onFeasibilityChange(Boolean value) {
        this.model.setBestScoreFeasible(value);
    }

    public void onBestScoreLimitChange(String value) {
        this.model.setBestScoreLimit(value);
    }

    public void onTerminationCompositionStyleChange(TerminationCompositionStyleModel value) {
        this.model.setTerminationCompositionStyle(value);
    }

    public void setExistingValue(Object value, TerminationConfigOption terminationConfigOption) {
        TerminationManager operation = this.terminationManagerMap.get(terminationConfigOption);
        if (operation != null) {
            operation.setExistingValue(value);
        }
    }

    public void setNewValue(TerminationConfigOption terminationConfigOption) {
        TerminationManager operation = this.terminationManagerMap.get(terminationConfigOption);
        if (operation != null) {
            operation.setNewValue();
        }
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    private void initTerminationManagerMap() {
        this.terminationManagerMap.put(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideTimeSpentInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setMillisecondsSpentLimit(null);
                TerminationTreeItemContent.this.model.setSecondsSpentLimit(null);
                TerminationTreeItemContent.this.model.setMinutesSpentLimit(null);
                TerminationTreeItemContent.this.model.setHoursSpentLimit(null);
                TerminationTreeItemContent.this.model.setDaysSpentLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setMillisecondsSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setMillisecondsSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.SECONDS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setSecondsSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setSecondsSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.MINUTES_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setMinutesSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setMinutesSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.HOURS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setHoursSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setHoursSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.DAYS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setDaysSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setDaysSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setMillisecondsSpent(0L);
                TerminationTreeItemContent.this.model.setMillisecondsSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setSecondsSpent(0L);
                TerminationTreeItemContent.this.model.setSecondsSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setMinutesSpent(5L);
                TerminationTreeItemContent.this.model.setMinutesSpentLimit(Long.valueOf(5L));
                TerminationTreeItemContent.this.view.setHoursSpent(0L);
                TerminationTreeItemContent.this.model.setHoursSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setDaysSpent(0L);
                TerminationTreeItemContent.this.model.setDaysSpentLimit(Long.valueOf(0L));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.TimeSpent"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.TimeSpentHelp"));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideUnimprovedTimeSpentInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setUnimprovedMillisecondsSpentLimit(null);
                TerminationTreeItemContent.this.model.setUnimprovedSecondsSpentLimit(null);
                TerminationTreeItemContent.this.model.setUnimprovedMinutesSpentLimit(null);
                TerminationTreeItemContent.this.model.setUnimprovedHoursSpentLimit(null);
                TerminationTreeItemContent.this.model.setUnimprovedDaysSpentLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setUnimprovedMillisecondsSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedMinutesSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.UNIMPROVED_SECONDS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setUnimprovedSecondsSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedSecondsSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.UNIMPROVED_MINUTES_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setUnimprovedMinutesSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedMinutesSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.UNIMPROVED_HOURS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setUnimprovedHoursSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedHoursSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
                value = TerminationTreeItemContent.this.terminationConfigForm.getTerminationValue(TerminationTreeItemContent.this.model, TerminationConfigOption.UNIMPROVED_DAYS_SPENT_LIMIT);
                TerminationTreeItemContent.this.view.setUnimprovedDaysSpent(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedDaysSpentLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setUnimprovedMillisecondsSpent(0L);
                TerminationTreeItemContent.this.model.setUnimprovedMillisecondsSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setUnimprovedSecondsSpent(0L);
                TerminationTreeItemContent.this.model.setUnimprovedSecondsSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setUnimprovedMinutesSpent(5L);
                TerminationTreeItemContent.this.model.setUnimprovedMinutesSpentLimit(Long.valueOf(5L));
                TerminationTreeItemContent.this.view.setUnimprovedHoursSpent(0L);
                TerminationTreeItemContent.this.model.setUnimprovedHoursSpentLimit(Long.valueOf(0L));
                TerminationTreeItemContent.this.view.setUnimprovedDaysSpent(0L);
                TerminationTreeItemContent.this.model.setUnimprovedDaysSpentLimit(Long.valueOf(0L));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedTimeSpent"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedTimeSpentHelp"));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.BEST_SCORE_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideBestScoreLimitInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setBestScoreLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setBestScoreLimit(value == null ? null : value.toString());
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.BestScoreLimit"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.BestScoreLimitHelp"));
            }

            @Override
            public void setNewValue() {
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.BEST_SCORE_FEASIBLE, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideBestScoreFeasibleInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setBestScoreFeasible(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setBestScoreFeasible(value == null ? null : Boolean.valueOf(value.toString()));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setBestScoreFeasible(true);
                TerminationTreeItemContent.this.model.setBestScoreFeasible(Boolean.valueOf(true));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.BestScoreFeasible"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.BestScoreFeasibleHelp"));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.STEP_COUNT_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideStepCountLimitInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setStepCountLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setStepCountLimit(value == null ? 0 : Integer.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setStepCountLimit(Integer.valueOf(value == null ? 0 : Integer.valueOf(value.toString())));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.StepCountLimit"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.StepCountLimitHelp"));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setStepCountLimit(0);
                TerminationTreeItemContent.this.model.setStepCountLimit(Integer.valueOf(0));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.UNIMPROVED_STEP_COUNT_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideUnimprovedStepCountLimitInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setUnimprovedStepCountLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setUnimprovedStepCountLimit(value == null ? 0 : Integer.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setUnimprovedStepCountLimit(Integer.valueOf(value == null ? 0 : Integer.valueOf(value.toString())));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedStepCountLimit"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedStepCountLimitHelp"));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setUnimprovedStepCountLimit(0);
                TerminationTreeItemContent.this.model.setUnimprovedStepCountLimit(Integer.valueOf(0));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.SCORE_CALCULATION_COUNT_LIMIT, new TerminationManager(){

            @Override
            public void hideViewInputs() {
                TerminationTreeItemContent.this.view.hideScoreCalculationCountLimitInput();
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setScoreCalculationCountLimit(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setScoreCalculationCountLimit(value == null ? 0L : Long.valueOf(value.toString()));
                TerminationTreeItemContent.this.model.setScoreCalculationCountLimit(Long.valueOf(value == null ? 0L : Long.valueOf(value.toString())));
            }

            @Override
            public void setLabelStrings() {
                TerminationTreeItemContent.this.view.setFormLabelText(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.ScoreCalculationCountLimit"));
                TerminationTreeItemContent.this.view.setFormLabelHelpContent(TerminationTreeItemContent.this.translationService.getTranslation("TerminationTreeItemContent.ScoreCalculationCountLimitHelp"));
            }

            @Override
            public void setNewValue() {
                TerminationTreeItemContent.this.view.setScoreCalculationCountLimit(0L);
                TerminationTreeItemContent.this.model.setScoreCalculationCountLimit(Long.valueOf(0L));
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.TERMINATION_COMPOSITION_STYLE, new TerminationManager(){

            @Override
            public void hideViewInputs() {
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent.this.model.setTerminationCompositionStyle(null);
            }

            @Override
            public void setExistingValue(Object value) {
                TerminationTreeItemContent.this.view.setTerminationCompositionStyle(value == null ? null : TerminationCompositionStyleModel.valueOf((String)value.toString()));
            }

            @Override
            public void setLabelStrings() {
            }

            @Override
            public void setNewValue() {
            }
        });
        this.terminationManagerMap.put(TerminationConfigOption.NESTED, new TerminationManager(){

            @Override
            public void hideViewInputs() {
            }

            @Override
            public void removeModelValue() {
                TerminationTreeItemContent parent = TerminationTreeItemContent.this.treeItem.getParentItem() == null ? TerminationTreeItemContent.this : (TerminationTreeItemContent)TerminationTreeItemContent.this.treeItem.getParentItem().getUserObject();
                parent.getModel().getTerminationConfigList().remove(TerminationTreeItemContent.this.model);
                if (parent.getModel().getTerminationConfigList().isEmpty()) {
                    parent.getModel().setTerminationConfigList(null);
                }
            }

            @Override
            public void setExistingValue(Object value) {
            }

            @Override
            public void setLabelStrings() {
            }

            @Override
            public void setNewValue() {
            }
        });
    }

    private static interface TerminationManager {
        public void hideViewInputs();

        public void removeModelValue();

        public void setExistingValue(Object var1);

        public void setNewValue();

        public void setLabelStrings();
    }
}

