/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicForm;
import org.optaplanner.workbench.screens.solver.client.editor.LocalSearchForm;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigFormView;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.LocalSearchPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.PhaseConfigModel;

public class PhaseConfigForm
implements IsWidget {
    private List<PhaseConfigModel> model;
    private List phaseFormList = new ArrayList();
    private PhaseConfigFormView view;
    private ManagedInstance<ConstructionHeuristicForm> constructionHeuristicFormProvider;
    private ManagedInstance<LocalSearchForm> localSearchFormProvider;

    @Inject
    public PhaseConfigForm(PhaseConfigFormView view, ManagedInstance<ConstructionHeuristicForm> constructionHeuristicFormProvider, ManagedInstance<LocalSearchForm> localSearchFormProvider) {
        this.view = view;
        this.constructionHeuristicFormProvider = constructionHeuristicFormProvider;
        this.localSearchFormProvider = localSearchFormProvider;
        view.setPresenter(this);
    }

    public void addConstructionHeuristic() {
        ConstructionHeuristicPhaseConfigModel constructionHeuristicPhaseConfigModel = new ConstructionHeuristicPhaseConfigModel();
        this.model.add((PhaseConfigModel)constructionHeuristicPhaseConfigModel);
        this.addConstructionHeuristic(constructionHeuristicPhaseConfigModel);
    }

    public void addConstructionHeuristic(ConstructionHeuristicPhaseConfigModel constructionHeuristicPhaseConfigModel) {
        if (this.phaseFormList.isEmpty()) {
            this.view.displayEmptyPhaseConfigurationLabel(false);
        }
        ConstructionHeuristicForm constructionHeuristicForm = (ConstructionHeuristicForm)this.constructionHeuristicFormProvider.get();
        constructionHeuristicForm.setPhaseConfigForm(this);
        constructionHeuristicForm.setModel(constructionHeuristicPhaseConfigModel);
        this.phaseFormList.add(constructionHeuristicForm);
        this.view.addConstructionHeuristic(constructionHeuristicForm.getElement());
    }

    public void removeConstructionHeuristic(ConstructionHeuristicForm constructionHeuristicForm) {
        this.phaseFormList.remove(constructionHeuristicForm);
        this.view.removeConstructionHeuristic(constructionHeuristicForm.getElement());
        this.model.remove(constructionHeuristicForm.getModel());
        this.constructionHeuristicFormProvider.destroy((Object)constructionHeuristicForm);
        if (this.phaseFormList.isEmpty()) {
            this.view.displayEmptyPhaseConfigurationLabel(true);
        }
    }

    public void addLocalSearch() {
        LocalSearchPhaseConfigModel localSearchPhaseConfigModel = new LocalSearchPhaseConfigModel();
        this.model.add((PhaseConfigModel)localSearchPhaseConfigModel);
        this.addLocalSearch(localSearchPhaseConfigModel);
    }

    public void addLocalSearch(LocalSearchPhaseConfigModel localSearchPhaseConfigModel) {
        if (this.phaseFormList.isEmpty()) {
            this.view.displayEmptyPhaseConfigurationLabel(false);
        }
        LocalSearchForm localSearchForm = (LocalSearchForm)this.localSearchFormProvider.get();
        localSearchForm.setPhaseConfigForm(this);
        localSearchForm.setModel(localSearchPhaseConfigModel);
        this.phaseFormList.add(localSearchForm);
        this.view.addLocalSearch(localSearchForm.getElement());
    }

    public void removeLocalSearch(LocalSearchForm localSearchForm) {
        this.phaseFormList.remove(localSearchForm);
        this.view.removeLocalSearch(localSearchForm.getElement());
        this.model.remove(localSearchForm.getModel());
        this.localSearchFormProvider.destroy((Object)localSearchForm);
        if (this.phaseFormList.isEmpty()) {
            this.view.displayEmptyPhaseConfigurationLabel(true);
        }
    }

    public List<PhaseConfigModel> getModel() {
        return this.model;
    }

    public void setModel(List<PhaseConfigModel> model) {
        this.model = model;
        for (PhaseConfigModel phaseConfigModel : model) {
            if (phaseConfigModel instanceof ConstructionHeuristicPhaseConfigModel) {
                this.addConstructionHeuristic((ConstructionHeuristicPhaseConfigModel)phaseConfigModel);
                continue;
            }
            if (!(phaseConfigModel instanceof LocalSearchPhaseConfigModel)) continue;
            this.addLocalSearch((LocalSearchPhaseConfigModel)phaseConfigModel);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

