/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigFormView;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContent;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigOption;

@Dependent
public class TerminationConfigForm
implements IsWidget {
    private TerminationConfigModel model;
    private TerminationConfigFormView view;
    private ManagedInstance<TerminationTreeItemContent> terminationTreeItemContentProvider;
    private TreeItem rootTreeItem;

    @Inject
    public TerminationConfigForm(TerminationConfigFormView view, ManagedInstance<TerminationTreeItemContent> terminationTreeItemContentProvider) {
        this.view = view;
        this.terminationTreeItemContentProvider = terminationTreeItemContentProvider;
    }

    public void displayEmptyTreeLabel(boolean visible) {
        this.view.displayEmptyTreeLabel(visible);
    }

    public void addNewTerminationType(String terminationType, TerminationTreeItemContent treeItemContent) {
        TerminationConfigModel terminationConfigModel;
        TreeItem nestedTreeItem = new TreeItem();
        this.insertTreeItem(treeItemContent.getTreeItem(), nestedTreeItem, TerminationConfigOption.valueOf((String)terminationType));
        treeItemContent.getTreeItem().setState(true);
        TerminationConfigOption terminationConfigOption = TerminationConfigOption.valueOf((String)terminationType);
        if (terminationConfigOption == TerminationConfigOption.NESTED) {
            TerminationConfigModel childTerminationConfigModel = new TerminationConfigModel();
            if (treeItemContent.getModel().getTerminationConfigList() == null) {
                treeItemContent.getModel().setTerminationConfigList(new ArrayList(1));
            }
            treeItemContent.getModel().getTerminationConfigList().add(childTerminationConfigModel);
            terminationConfigModel = childTerminationConfigModel;
        } else {
            terminationConfigModel = treeItemContent.getModel();
        }
        TerminationTreeItemContent terminationTreeItemContent = this.createTerminationTreeItemContent(terminationConfigOption, nestedTreeItem, terminationConfigModel);
        terminationTreeItemContent.setNewValue(terminationConfigOption);
        treeItemContent.removeDropDownOption(TerminationConfigOption.valueOf((String)terminationType));
        this.view.displayEmptyTreeLabel(this.rootTreeItem.getChildCount() == 0);
        this.view.refreshTree();
    }

    private void insertTreeItem(TreeItem treeItem, TreeItem nestedTreeItem, TerminationConfigOption terminationConfigOption) {
        if (treeItem.getChildCount() == 0) {
            treeItem.addItem(nestedTreeItem);
        } else {
            for (int i = 0; i < treeItem.getChildCount(); ++i) {
                TerminationTreeItemContent childTreeItemContent = (TerminationTreeItemContent)treeItem.getChild(i).getUserObject();
                if (terminationConfigOption.ordinal() < childTreeItemContent.getTerminationConfigOption().ordinal()) {
                    treeItem.insertItem(i, nestedTreeItem);
                    break;
                }
                if (i != treeItem.getChildCount() - 1) continue;
                treeItem.addItem(nestedTreeItem);
                break;
            }
        }
    }

    private TerminationTreeItemContent createTerminationTreeItemContent(TerminationConfigOption terminationConfigOption, TreeItem treeItem, TerminationConfigModel terminationConfigModel) {
        TerminationTreeItemContent terminationTreeItemContent = (TerminationTreeItemContent)this.terminationTreeItemContentProvider.get();
        terminationTreeItemContent.setTerminationConfigForm(this);
        terminationTreeItemContent.setTerminationConfigOption(terminationConfigOption);
        terminationTreeItemContent.setTreeItem(treeItem);
        terminationTreeItemContent.setModel(terminationConfigModel);
        treeItem.setUserObject((Object)terminationTreeItemContent);
        treeItem.setWidget((Widget)ElementWrapperWidget.getWidget((HTMLElement)terminationTreeItemContent.getElement()));
        treeItem.setState(true);
        return terminationTreeItemContent;
    }

    public void destroyTerminationTreeItemContent(TerminationTreeItemContent terminationTreeItemContent) {
        this.terminationTreeItemContentProvider.destroy((Object)terminationTreeItemContent);
    }

    public void setModel(TerminationConfigModel terminationConfigModel) {
        this.model = terminationConfigModel;
        this.initTerminationTree(this.model);
    }

    private void initTerminationTree(TerminationConfigModel terminationConfigModel) {
        this.rootTreeItem = new TreeItem();
        this.initTerminationTreeItemHierarchy(terminationConfigModel, this.rootTreeItem);
        this.view.initTree(this.rootTreeItem);
        this.rootTreeItem.setState(true);
        this.view.displayEmptyTreeLabel(this.rootTreeItem.getChildCount() == 0);
        this.view.refreshTree();
    }

    public TreeItem getRootTreeItem() {
        return this.rootTreeItem;
    }

    private void initTerminationTreeItemHierarchy(TerminationConfigModel terminationConfigModel, TreeItem treeItem) {
        TerminationTreeItemContent terminationTreeItemContent = this.createTerminationTreeItemContent(TerminationConfigOption.NESTED, treeItem, terminationConfigModel);
        TerminationConfigOption timeSpentTerminationOption = null;
        boolean timeSpentInserted = false;
        boolean unimprovedTimeSpentInserted = false;
        block0: for (TerminationConfigOption terminationConfigOption : TerminationConfigOption.values()) {
            TerminationTreeItemContent treeItemContent;
            timeSpentTerminationOption = null;
            Object terminationValue = this.getTerminationValue(terminationConfigModel, terminationConfigOption);
            if (terminationConfigOption == TerminationConfigOption.TERMINATION_COMPOSITION_STYLE) {
                TerminationTreeItemContent parentTreeItemContent = (TerminationTreeItemContent)treeItem.getUserObject();
                parentTreeItemContent.setExistingValue(terminationValue, TerminationConfigOption.TERMINATION_COMPOSITION_STYLE);
                continue;
            }
            if (terminationValue != null) {
                if (timeSpentInserted && (terminationConfigOption == TerminationConfigOption.MILLISECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.SECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.MINUTES_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.HOURS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.DAYS_SPENT_LIMIT)) {
                    for (int i = 0; i < treeItem.getChildCount(); ++i) {
                        treeItemContent = (TerminationTreeItemContent)treeItem.getChild(i).getUserObject();
                        if (treeItemContent.getTerminationConfigOption() != TerminationConfigOption.MILLISECONDS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.SECONDS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.MINUTES_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.HOURS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.DAYS_SPENT_LIMIT) continue;
                        treeItemContent.setTerminationConfigOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
                        treeItemContent.setExistingValue(terminationValue, TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
                        continue block0;
                    }
                } else if (terminationConfigOption == TerminationConfigOption.MILLISECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.SECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.MINUTES_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.HOURS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.DAYS_SPENT_LIMIT) {
                    timeSpentTerminationOption = TerminationConfigOption.MILLISECONDS_SPENT_LIMIT;
                    timeSpentInserted = true;
                }
            }
            if (terminationValue != null) {
                if (unimprovedTimeSpentInserted && (terminationConfigOption == TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_SECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_MINUTES_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_HOURS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_DAYS_SPENT_LIMIT)) {
                    for (int i = 0; i < treeItem.getChildCount(); ++i) {
                        treeItemContent = (TerminationTreeItemContent)treeItem.getChild(i).getUserObject();
                        if (treeItemContent.getTerminationConfigOption() != TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.UNIMPROVED_SECONDS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.UNIMPROVED_MINUTES_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.UNIMPROVED_HOURS_SPENT_LIMIT && treeItemContent.getTerminationConfigOption() != TerminationConfigOption.UNIMPROVED_DAYS_SPENT_LIMIT) continue;
                        treeItemContent.setTerminationConfigOption(TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT);
                        treeItemContent.setExistingValue(terminationValue, TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT);
                        continue block0;
                    }
                } else if (terminationConfigOption == TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_SECONDS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_MINUTES_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_HOURS_SPENT_LIMIT || terminationConfigOption == TerminationConfigOption.UNIMPROVED_DAYS_SPENT_LIMIT) {
                    timeSpentTerminationOption = TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT;
                    unimprovedTimeSpentInserted = true;
                }
            }
            if (terminationValue == null || TerminationConfigOption.NESTED.equals((Object)terminationConfigOption)) continue;
            TreeItem nestedTreeItem = new TreeItem();
            if (timeSpentTerminationOption != null) {
                terminationConfigOption = timeSpentTerminationOption;
            }
            this.insertTreeItem(treeItem, nestedTreeItem, terminationConfigOption);
            terminationTreeItemContent.removeDropDownOption(terminationConfigOption);
            TerminationTreeItemContent nestedTerminationTreeItemContent = this.createTerminationTreeItemContent(terminationConfigOption, nestedTreeItem, terminationConfigModel);
            nestedTerminationTreeItemContent.setExistingValue(terminationValue, terminationConfigOption);
        }
        if (terminationConfigModel.getTerminationConfigList() != null) {
            for (TerminationConfigModel nestedTerminationConfigModel : terminationConfigModel.getTerminationConfigList()) {
                TreeItem nestedTreeItem = new TreeItem();
                treeItem.addItem(nestedTreeItem);
                this.initTerminationTreeItemHierarchy(nestedTerminationConfigModel, nestedTreeItem);
                nestedTreeItem.setState(true);
            }
        }
    }

    public Object getTerminationValue(TerminationConfigModel terminationConfigModel, TerminationConfigOption terminationConfigOption) {
        switch (terminationConfigOption) {
            case MILLISECONDS_SPENT_LIMIT: {
                return terminationConfigModel.getMillisecondsSpentLimit();
            }
            case SECONDS_SPENT_LIMIT: {
                return terminationConfigModel.getSecondsSpentLimit();
            }
            case MINUTES_SPENT_LIMIT: {
                return terminationConfigModel.getMinutesSpentLimit();
            }
            case HOURS_SPENT_LIMIT: {
                return terminationConfigModel.getHoursSpentLimit();
            }
            case DAYS_SPENT_LIMIT: {
                return terminationConfigModel.getDaysSpentLimit();
            }
            case UNIMPROVED_MILLISECONDS_SPENT_LIMIT: {
                return terminationConfigModel.getUnimprovedMillisecondsSpentLimit();
            }
            case UNIMPROVED_SECONDS_SPENT_LIMIT: {
                return terminationConfigModel.getUnimprovedSecondsSpentLimit();
            }
            case UNIMPROVED_MINUTES_SPENT_LIMIT: {
                return terminationConfigModel.getUnimprovedMinutesSpentLimit();
            }
            case UNIMPROVED_HOURS_SPENT_LIMIT: {
                return terminationConfigModel.getUnimprovedHoursSpentLimit();
            }
            case UNIMPROVED_DAYS_SPENT_LIMIT: {
                return terminationConfigModel.getUnimprovedDaysSpentLimit();
            }
            case BEST_SCORE_LIMIT: {
                return terminationConfigModel.getBestScoreLimit();
            }
            case BEST_SCORE_FEASIBLE: {
                return terminationConfigModel.getBestScoreFeasible();
            }
            case STEP_COUNT_LIMIT: {
                return terminationConfigModel.getStepCountLimit();
            }
            case UNIMPROVED_STEP_COUNT_LIMIT: {
                return terminationConfigModel.getUnimprovedStepCountLimit();
            }
            case SCORE_CALCULATION_COUNT_LIMIT: {
                return terminationConfigModel.getScoreCalculationCountLimit();
            }
            case TERMINATION_COMPOSITION_STYLE: {
                return terminationConfigModel.getTerminationCompositionStyle();
            }
        }
        return null;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

