/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.optaplanner.workbench.screens.solver.client.resources.SolverEditorResources;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewSolverHandler
extends DefaultNewResourceHandler {
    public static final String PLANNER_AVAILABLE = "planner.available";
    private Caller<SolverEditorService> solverService;
    private SolverResourceType resourceType;
    private BusyIndicatorView busyIndicatorView;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private TranslationService translationService;

    public NewSolverHandler() {
    }

    @Inject
    public NewSolverHandler(Caller<SolverEditorService> solverService, SolverResourceType resourceType, BusyIndicatorView busyIndicatorView, AuthorizationManager authorizationManager, SessionInfo sessionInfo, TranslationService translationService) {
        this.solverService = solverService;
        this.resourceType = resourceType;
        this.busyIndicatorView = busyIndicatorView;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.translationService = translationService;
    }

    public String getDescription() {
        return this.translationService.getTranslation("NewSolverHandler.Description");
    }

    public IsWidget getIcon() {
        return new Image(SolverEditorResources.INSTANCE.images().typeSolver());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((SolverEditorService)this.solverService.call(this.getSuccessCallback(presenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), (Object)new SolverConfigModel(), "");
    }

    public boolean canCreate() {
        return this.authorizationManager.authorize(PLANNER_AVAILABLE, this.sessionInfo.getIdentity());
    }
}

