/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.XMLViewer;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.client.util.SuperDevModeFlag;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverModelContent;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.views.pfly.multipage.PageImpl;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.callbacks.CommandErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="OptaPlannerSolverEditor", supportedTypes={SolverResourceType.class}, priority=10)
public class SolverEditorPresenter
extends KieEditor<SolverConfigModel> {
    public static final String EDITOR_ID = "OptaPlannerSolverEditor";
    private Caller<SolverEditorService> solverService;
    private Event<NotificationEvent> notification;
    private SolverResourceType solverResourceType;
    private XMLViewer xmlViewer;
    private ValidationPopup validationPopup;
    private TranslationService translationService;
    private SolverEditorView view;
    private SolverConfigModel model;

    @Inject
    public SolverEditorPresenter(SolverEditorView view, SolverResourceType solverResourceType, XMLViewer xmlViewer, Event<NotificationEvent> notification, Caller<SolverEditorService> solverService, ValidationPopup validationPopup, TranslationService translationService) {
        super((KieEditorView)view);
        this.xmlViewer = xmlViewer;
        this.view = view;
        this.solverResourceType = solverResourceType;
        this.notification = notification;
        this.solverService = solverService;
        this.validationPopup = validationPopup;
        this.translationService = translationService;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.solverResourceType);
    }

    protected void makeMenuBar() {
        SuperDevModeFlag superDevModeFlag = (SuperDevModeFlag)GWT.create(SuperDevModeFlag.class);
        if (superDevModeFlag.isSuperDevModeUsed()) {
            this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> ((SolverEditorPresenter)this).onSave())).addCopy((Path)this.versionRecordManager.getCurrentPath(), this.getCopyValidator()).addRename(this.getSaveAndRename()).addDelete((Path)this.versionRecordManager.getPathToLatest()).addValidate(this.getValidateCommand()).addCommand(this.translationService.getTranslation("SolverEditorPresenter.SmokeTest"), this.onSmokeTest()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
        } else {
            super.makeMenuBar();
        }
    }

    protected void loadContent() {
        this.view.showLoading();
        ((SolverEditorService)this.solverService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected Supplier<SolverConfigModel> getContentSupplier() {
        return this::getModel;
    }

    public Validator getRenameValidator() {
        return this.fileNameValidator;
    }

    protected Caller<? extends SupportsSaveAndRename<SolverConfigModel, Metadata>> getSaveAndRenameServiceCaller() {
        return this.solverService;
    }

    private RemoteCallback<SolverModelContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<SolverModelContent>(){

            public void callback(SolverModelContent content) {
                if (SolverEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                SolverEditorPresenter.this.resetEditorPages(content.getOverview());
                SolverEditorPresenter.this.addXMLSourcePage();
                SolverEditorPresenter.this.model = content.getConfig();
                SolverEditorPresenter.this.view.setTerminationConfigModel(SolverEditorPresenter.this.model.getTermination());
                SolverEditorPresenter.this.view.setScoreDirectorFactoryConfig(SolverEditorPresenter.this.model.getScoreDirectorFactoryConfig(), (Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath());
                SolverEditorPresenter.this.view.setPhaseConfigModel(SolverEditorPresenter.this.model.getPhaseConfigList());
                SolverEditorPresenter.this.view.hideBusyIndicator();
                SolverEditorPresenter.this.createOriginalHash(SolverEditorPresenter.this.model);
            }
        };
    }

    private void addXMLSourcePage() {
        this.addPage((Page)new PageImpl(this.xmlViewer, this.translationService.getTranslation("SolverEditorPresenter.Source")){

            public void onFocus() {
                ((SolverEditorService)SolverEditorPresenter.this.solverService.call(SolverEditorPresenter.this.getToSourceRemoteCallback())).toSource((Path)SolverEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)SolverEditorPresenter.this.model);
            }
        });
    }

    private RemoteCallback<String> getToSourceRemoteCallback() {
        return new RemoteCallback<String>(){

            public void callback(String xml) {
                SolverEditorPresenter.this.xmlViewer.setContent(xml);
            }
        };
    }

    protected void onValidate(Command finished) {
        ((SolverEditorService)this.solverService.call((RemoteCallback)this.validationPopup.getValidationCallback(finished), (ErrorCallback)new CommandErrorCallback(finished))).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    private RemoteCallback<List<ValidationMessage>> getRemoteCallback(final String message) {
        return new RemoteCallback<List<ValidationMessage>>(){

            public void callback(List<ValidationMessage> results) {
                if (results == null || results.isEmpty()) {
                    SolverEditorPresenter.this.notification.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.SUCCESS));
                } else {
                    SolverEditorPresenter.this.validationPopup.showMessages(results);
                }
            }
        };
    }

    protected Command onSmokeTest() {
        return () -> ((SolverEditorService)this.solverService.call(this.getRemoteCallback(this.translationService.getTranslation("SolverEditorPresenter.SmokeTestSuccess")))).smokeTest((Path)this.versionRecordManager.getCurrentPath(), this.model);
    }

    protected void save(String commitMessage) {
        ((SolverEditorService)this.solverService.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    protected String getEditorIdentifier() {
        return EDITOR_ID;
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        super.onClose();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    SolverConfigModel getModel() {
        return this.model;
    }
}

