/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicFormView;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.client.resources.i18n.SolverEditorLookupConstants;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicTypeModel;
import org.uberfire.commons.data.Pair;

@Dependent
public class ConstructionHeuristicForm
implements IsElement {
    private final ConstructionHeuristicFormView view;
    private ConstructionHeuristicPhaseConfigModel model;
    private PhaseConfigForm phaseConfigForm;
    private SolverEditorLookupConstants solverEditorLookupConstants = (SolverEditorLookupConstants)GWT.create(SolverEditorLookupConstants.class);

    @Inject
    public ConstructionHeuristicForm(ConstructionHeuristicFormView view) {
        this.view = view;
        view.setPresenter(this);
        this.initConstructionHeuristicTypeSelectOptions();
        this.initEntitySorterMannerSelectOptions();
    }

    private void initConstructionHeuristicTypeSelectOptions() {
        ArrayList<Pair<String, String>> constructionHeuristicTypeOptions = new ArrayList<Pair<String, String>>();
        for (ConstructionHeuristicTypeModel constructionHeuristicTypeModel : ConstructionHeuristicTypeModel.values()) {
            Pair option = new Pair((Object)this.solverEditorLookupConstants.getString(constructionHeuristicTypeModel.name()), (Object)constructionHeuristicTypeModel.name());
            constructionHeuristicTypeOptions.add((Pair<String, String>)option);
        }
        this.view.initConstructionHeuristicTypeSelectOptions(constructionHeuristicTypeOptions);
    }

    private void initEntitySorterMannerSelectOptions() {
        ArrayList<Pair<String, String>> entitySorterMannerOptions = new ArrayList<Pair<String, String>>();
        for (EntitySorterManner entitySorterManner : EntitySorterManner.values()) {
            Pair option = new Pair((Object)this.solverEditorLookupConstants.getString(entitySorterManner.name()), (Object)entitySorterManner.name());
            entitySorterMannerOptions.add((Pair<String, String>)option);
        }
        this.view.initEntitySorterMannerSelectOptions(entitySorterMannerOptions);
    }

    public void setPhaseConfigForm(PhaseConfigForm phaseConfigForm) {
        this.phaseConfigForm = phaseConfigForm;
    }

    public void onConstructionHeuristicTypeSelected(String constructionHeuristicType) {
        this.model.setConstructionHeuristicType(ConstructionHeuristicType.valueOf((String)constructionHeuristicType));
    }

    public void onEntitySorterMannerSelected(String entitySorterManner) {
        this.model.setEntitySorterManner(EntitySorterManner.valueOf((String)entitySorterManner));
    }

    public void onConstructionHeuristicRemoved() {
        this.phaseConfigForm.removeConstructionHeuristic(this);
    }

    public ConstructionHeuristicPhaseConfigModel getModel() {
        return this.model;
    }

    public void setModel(ConstructionHeuristicPhaseConfigModel model) {
        this.model = model;
        if (model.getConstructionHeuristicType() == null) {
            model.setConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT);
        }
        this.view.setSelectedConstructionHeuristicType(model.getConstructionHeuristicType().name());
        if (model.getEntitySorterManner() == null) {
            model.setEntitySorterManner(EntitySorterManner.NONE);
        }
        this.view.setSelectedEntitySorterManner(model.getEntitySorterManner().name());
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }
}

