/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.jboss.errai.common.client.dom.CheckboxInput;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.NumberInput;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContent;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContentView;
import org.optaplanner.workbench.screens.solver.model.TerminationCompositionStyleModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigOption;
import org.uberfire.client.views.pfly.widgets.FormLabelHelp;
import org.uberfire.client.views.pfly.widgets.HelpIcon;

@Dependent
@Templated
public class TerminationTreeItemContentViewImpl
implements TerminationTreeItemContentView {
    @Inject
    @DataField(value="view")
    Div view;
    @Inject
    @DataField(value="addTerminationDiv")
    Div addTerminationDiv;
    @Inject
    @DataField(value="formLabelDiv")
    Div formLabelDiv;
    @Inject
    @DataField(value="formLabel")
    FormLabelHelp formLabel;
    @Inject
    @DataField(value="dropDownHelpIcon")
    HelpIcon dropDownHelpIcon;
    @Inject
    @DataField(value="timeSpentDiv")
    Div timeSpentDiv;
    @DataField(value="dropdownMenuList")
    DropDownMenu dropdownMenuList;
    @Inject
    @DataField(value="terminationCompositionStyleSelect")
    Select terminationCompositionStyleSelect;
    @Inject
    @DataField(value="daysSpentInput")
    NumberInput daysSpentInput;
    @Inject
    @DataField(value="hoursSpentInput")
    NumberInput hoursSpentInput;
    @Inject
    @DataField(value="minutesSpentInput")
    NumberInput minutesSpentInput;
    @Inject
    @DataField(value="secondsSpentInput")
    NumberInput secondsSpentInput;
    @Inject
    @DataField(value="millisecondsSpentInput")
    NumberInput millisecondsSpentInput;
    @Inject
    @DataField(value="unimprovedTimeSpentDiv")
    Div unimprovedTimeSpentDiv;
    @Inject
    @DataField(value="unimprovedDaysSpentInput")
    NumberInput unimprovedDaysSpentInput;
    @Inject
    @DataField(value="unimprovedHoursSpentInput")
    NumberInput unimprovedHoursSpentInput;
    @Inject
    @DataField(value="unimprovedMinutesSpentInput")
    NumberInput unimprovedMinutesSpentInput;
    @Inject
    @DataField(value="unimprovedSecondsSpentInput")
    NumberInput unimprovedSecondsSpentInput;
    @Inject
    @DataField(value="unimprovedMillisecondsSpentInput")
    NumberInput unimprovedMillisecondsSpentInput;
    @Inject
    @DataField(value="stepCountLimitInput")
    NumberInput stepCountLimitInput;
    @Inject
    @DataField(value="unimprovedStepCountLimitInput")
    NumberInput unimprovedStepCountLimitInput;
    @Inject
    @DataField(value="scoreCalculationCountLimitInput")
    NumberInput scoreCalculationCountLimitInput;
    @Inject
    @DataField(value="bestScoreInput")
    TextInput bestScoreInput;
    @Inject
    @DataField(value="bestScoreFeasibleInput")
    CheckboxInput bestScoreFeasibleInput;
    @DataField(value="removeTerminationButton")
    Button removeTerminationButton;
    private TranslationService translationService;
    private TerminationTreeItemContent presenter;
    private Map<TerminationConfigOption, String> dropDownNameMap = new HashMap<TerminationConfigOption, String>();

    @Inject
    public TerminationTreeItemContentViewImpl(Button removeTerminationButton, DropDownMenu dropdownMenuList, TranslationService translationService) {
        this.removeTerminationButton = removeTerminationButton;
        this.dropdownMenuList = dropdownMenuList;
        this.translationService = translationService;
        removeTerminationButton.addClickHandler(h -> this.presenter.removeTreeItem());
        this.initDropDownList();
    }

    private void initDropDownList() {
        String itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.TimeSpent");
        this.dropDownNameMap.put(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT, itemMessage);
        AnchorListItem listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedTimeSpent");
        this.dropDownNameMap.put(TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.BestScoreLimit");
        this.dropDownNameMap.put(TerminationConfigOption.BEST_SCORE_LIMIT, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.BEST_SCORE_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.BestScoreFeasible");
        this.dropDownNameMap.put(TerminationConfigOption.BEST_SCORE_FEASIBLE, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.BEST_SCORE_FEASIBLE.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.StepCountLimit");
        this.dropDownNameMap.put(TerminationConfigOption.STEP_COUNT_LIMIT, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.STEP_COUNT_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.UnimprovedStepCountLimit");
        this.dropDownNameMap.put(TerminationConfigOption.UNIMPROVED_STEP_COUNT_LIMIT, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.UNIMPROVED_STEP_COUNT_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContent.ScoreCalculationCountLimit");
        this.dropDownNameMap.put(TerminationConfigOption.SCORE_CALCULATION_COUNT_LIMIT, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.SCORE_CALCULATION_COUNT_LIMIT.name()));
        this.dropdownMenuList.add((Widget)listItem);
        itemMessage = this.translationService.getTranslation("TerminationTreeItemContentViewImpl.NestedTermination");
        this.dropDownNameMap.put(TerminationConfigOption.NESTED, itemMessage);
        listItem = new AnchorListItem(itemMessage);
        listItem.addClickHandler(h -> this.presenter.onTerminationTypeSelected(TerminationConfigOption.NESTED.name()));
        this.dropdownMenuList.add((Widget)listItem);
    }

    @EventHandler(value={"daysSpentInput"})
    public void handleDaysSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.daysSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onDaysSpentChange(Long.parseLong(this.daysSpentInput.getValue()));
        } else {
            this.presenter.onDaysSpentChange(0L);
            this.daysSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"hoursSpentInput"})
    public void handleHoursSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.hoursSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onHoursSpentChange(Long.parseLong(this.hoursSpentInput.getValue()));
        } else {
            this.presenter.onHoursSpentChange(0L);
            this.hoursSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"minutesSpentInput"})
    public void handleMinutesSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.minutesSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onMinutesSpentChange(Long.parseLong(this.minutesSpentInput.getValue()));
        } else {
            this.presenter.onMinutesSpentChange(0L);
            this.minutesSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"secondsSpentInput"})
    public void handleSecondsSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.secondsSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onSecondsSpentChange(Long.parseLong(this.secondsSpentInput.getValue()));
        } else {
            this.presenter.onSecondsSpentChange(0L);
            this.secondsSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"millisecondsSpentInput"})
    public void handleMilliSecondsSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.millisecondsSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onMillisecondsSpentChange(Long.parseLong(this.millisecondsSpentInput.getValue()));
        } else {
            this.presenter.onMillisecondsSpentChange(0L);
            this.millisecondsSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedDaysSpentInput"})
    public void handleUnimprovedDaysSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedDaysSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedDaysSpentChange(Long.parseLong(this.unimprovedDaysSpentInput.getValue()));
        } else {
            this.presenter.onUnimprovedDaysSpentChange(0L);
            this.unimprovedDaysSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedHoursSpentInput"})
    public void handleUnimprovedHoursSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedHoursSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedHoursSpentChange(Long.parseLong(this.unimprovedHoursSpentInput.getValue()));
        } else {
            this.presenter.onUnimprovedHoursSpentChange(0L);
            this.unimprovedHoursSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedMinutesSpentInput"})
    public void handleUnimprovedMinutesSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedMinutesSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedMinutesSpentChange(Long.parseLong(this.unimprovedMinutesSpentInput.getValue()));
        } else {
            this.presenter.onUnimprovedMinutesSpentChange(0L);
            this.unimprovedMinutesSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedSecondsSpentInput"})
    public void handleUnimprovedSecondsSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedSecondsSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedSecondsSpentChange(Long.parseLong(this.unimprovedSecondsSpentInput.getValue()));
        } else {
            this.presenter.onUnimprovedSecondsSpentChange(0L);
            this.unimprovedSecondsSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedMillisecondsSpentInput"})
    public void handleUnimprovedMilliSecondsSpentInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedMillisecondsSpentInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedMillisecondsSpentChange(Long.parseLong(this.unimprovedMillisecondsSpentInput.getValue()));
        } else {
            this.presenter.onUnimprovedMillisecondsSpentChange(0L);
            this.unimprovedMillisecondsSpentInput.setValue("0");
        }
    }

    @EventHandler(value={"stepCountLimitInput"})
    public void onStepCountLimitInputChange(ChangeEvent event) {
        boolean isNumeric = this.stepCountLimitInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onStepCountLimitChange(Integer.parseInt(this.stepCountLimitInput.getValue()));
        } else {
            this.presenter.onStepCountLimitChange(0);
            this.stepCountLimitInput.setValue("0");
        }
    }

    @EventHandler(value={"unimprovedStepCountLimitInput"})
    public void onUnimprovedStepCountLimitInputChange(ChangeEvent event) {
        boolean isNumeric = this.unimprovedStepCountLimitInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onUnimprovedStepCountLimitChange(Integer.parseInt(this.unimprovedStepCountLimitInput.getValue()));
        } else {
            this.presenter.onUnimprovedStepCountLimitChange(0);
            this.unimprovedStepCountLimitInput.setValue("0");
        }
    }

    @EventHandler(value={"scoreCalculationCountLimitInput"})
    public void onScoreCalculationLimitInputChange(ChangeEvent event) {
        boolean isNumeric = this.scoreCalculationCountLimitInput.getValue().matches("\\d+");
        if (isNumeric) {
            this.presenter.onScoreCalculationLimitChange(Long.parseLong(this.scoreCalculationCountLimitInput.getValue()));
        } else {
            this.presenter.onScoreCalculationLimitChange(0L);
            this.scoreCalculationCountLimitInput.setValue("0");
        }
    }

    @EventHandler(value={"bestScoreInput"})
    public void handleBestScoreInputChange(ChangeEvent event) {
        String value = this.bestScoreInput.getValue().isEmpty() ? null : this.bestScoreInput.getValue();
        this.presenter.onBestScoreLimitChange(value);
    }

    @EventHandler(value={"bestScoreFeasibleInput"})
    public void handleBestScoreFeasibleInputChange(ChangeEvent event) {
        this.presenter.onFeasibilityChange(this.bestScoreFeasibleInput.getChecked());
    }

    @EventHandler(value={"terminationCompositionStyleSelect"})
    public void handleTerminationCompositionStyleSelectChange(ChangeEvent event) {
        this.presenter.onTerminationCompositionStyleChange("and".equals(this.terminationCompositionStyleSelect.getValue()) ? TerminationCompositionStyleModel.AND : TerminationCompositionStyleModel.OR);
    }

    @Override
    public void setPresenter(TerminationTreeItemContent presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setRoot(boolean root) {
        if (root) {
            this.removeTerminationButton.getElement().getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void addDropDownOption(TerminationConfigOption terminationConfigOption) {
        if (terminationConfigOption == TerminationConfigOption.NESTED) {
            return;
        }
        AnchorListItem li1 = new AnchorListItem(this.dropDownNameMap.get(terminationConfigOption));
        li1.addClickHandler(h -> this.presenter.onTerminationTypeSelected(terminationConfigOption.name()));
        for (int i = 0; i < this.dropdownMenuList.getWidgetCount(); ++i) {
            AnchorListItem item = (AnchorListItem)this.dropdownMenuList.getWidget(i);
            TerminationConfigOption dropDownTerminationConfigOption = this.getDropDownOption(item.getText());
            if (dropDownTerminationConfigOption == null || terminationConfigOption.ordinal() < dropDownTerminationConfigOption.ordinal()) {
                this.dropdownMenuList.insert((Widget)li1, i);
                break;
            }
            if (i != this.dropdownMenuList.getWidgetCount() - 1) continue;
            this.dropdownMenuList.add((Widget)li1);
        }
    }

    private TerminationConfigOption getDropDownOption(String text) {
        for (Map.Entry<TerminationConfigOption, String> entry : this.dropDownNameMap.entrySet()) {
            if (!entry.getValue().equals(text)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void removeDropDownOption(TerminationConfigOption option) {
        for (int i = 0; i < this.dropdownMenuList.getWidgetCount(); ++i) {
            AnchorListItem item = (AnchorListItem)this.dropdownMenuList.getWidget(i);
            if (!this.dropDownNameMap.get(option).equals(item.getText())) continue;
            this.dropdownMenuList.remove((Widget)item);
            break;
        }
    }

    @Override
    public void setNestedTreeItem(boolean nested) {
        if (nested) {
            this.formLabelDiv.getStyle().setProperty("display", "none");
        } else {
            this.addTerminationDiv.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void hideTimeSpentInput() {
        this.timeSpentDiv.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideUnimprovedTimeSpentInput() {
        this.unimprovedTimeSpentDiv.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideStepCountLimitInput() {
        this.stepCountLimitInput.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideUnimprovedStepCountLimitInput() {
        this.unimprovedStepCountLimitInput.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideScoreCalculationCountLimitInput() {
        this.scoreCalculationCountLimitInput.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideBestScoreFeasibleInput() {
        this.bestScoreFeasibleInput.getStyle().setProperty("display", "none");
    }

    @Override
    public void hideBestScoreLimitInput() {
        this.bestScoreInput.getStyle().setProperty("display", "none");
    }

    @Override
    public void setFormLabelText(String text) {
        this.formLabel.setText(text);
    }

    @Override
    public void setFormLabelHelpContent(String content) {
        this.formLabel.setHelpContent(content);
    }

    @Override
    public void setDropDownHelpContent(String content) {
        this.dropDownHelpIcon.setHelpContent(content);
    }

    @Override
    public void setDaysSpent(Long value) {
        this.daysSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setHoursSpent(Long value) {
        this.hoursSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setMinutesSpent(Long value) {
        this.minutesSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setSecondsSpent(Long value) {
        this.secondsSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setMillisecondsSpent(Long value) {
        this.millisecondsSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedDaysSpent(Long value) {
        this.unimprovedDaysSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedHoursSpent(Long value) {
        this.unimprovedHoursSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedMinutesSpent(Long value) {
        this.unimprovedMinutesSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedSecondsSpent(Long value) {
        this.unimprovedSecondsSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedMillisecondsSpent(Long value) {
        this.unimprovedMillisecondsSpentInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setStepCountLimit(Integer value) {
        this.stepCountLimitInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setUnimprovedStepCountLimit(Integer value) {
        this.unimprovedStepCountLimitInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setScoreCalculationCountLimit(Long value) {
        this.scoreCalculationCountLimitInput.setValue(value == null ? "0" : value.toString());
    }

    @Override
    public void setBestScoreFeasible(Boolean value) {
        this.bestScoreFeasibleInput.setChecked(value == null ? false : value);
    }

    @Override
    public void setBestScoreLimit(String value) {
        this.bestScoreInput.setValue(value);
    }

    @Override
    public void setTerminationCompositionStyle(TerminationCompositionStyleModel value) {
        this.terminationCompositionStyleSelect.setValue(value == TerminationCompositionStyleModel.AND ? "and" : "or");
    }

    public HTMLElement getElement() {
        return this.view;
    }
}

