/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.rotation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.service.rotation.RotationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/rotation"})
@Validated
@Api(tags={"Rotation"})
public class RotationController {
    private final RotationService rotationService;

    public RotationController(RotationService rotationService) {
        this.rotationService = rotationService;
        Assert.notNull((Object)rotationService, (String)"rotationService must not be null.");
    }

    @ApiOperation(value="Get a list of all shift templates")
    @GetMapping(value={"/"})
    public ResponseEntity<List<ShiftTemplateView>> getShiftTemplateList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rotationService.getShiftTemplateList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift template by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ShiftTemplateView> getShiftTemplate(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.rotationService.getShiftTemplate(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a shift template")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteShiftTemplate(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.rotationService.deleteShiftTemplate(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new shift template")
    @PostMapping(value={"/add"})
    public ResponseEntity<ShiftTemplateView> createShiftTemplate(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ShiftTemplateView shiftTemplateView) {
        return new ResponseEntity((Object)this.rotationService.createShiftTemplate(tenantId, shiftTemplateView), HttpStatus.OK);
    }

    @ApiOperation(value="Update a shift template")
    @PutMapping(value={"/update"})
    public ResponseEntity<ShiftTemplateView> updateShiftTemplate(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ShiftTemplateView shiftTemplateView) {
        return new ResponseEntity((Object)this.rotationService.updateShiftTemplate(tenantId, shiftTemplateView), HttpStatus.OK);
    }
}

