/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityNotFoundException;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeService
extends AbstractRestService {
    private final EmployeeRepository employeeRepository;
    private final EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private final RosterStateRepository rosterStateRepository;

    public EmployeeService(EmployeeRepository employeeRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, RosterStateRepository rosterStateRepository) {
        this.employeeRepository = employeeRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.rosterStateRepository = rosterStateRepository;
    }

    public Employee convertFromEmployeeView(Integer tenantId, EmployeeView employeeView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeView);
        Employee employee = new Employee(tenantId, employeeView.getName(), employeeView.getContract(), employeeView.getSkillProficiencySet());
        employee.setId(employeeView.getId());
        employee.setVersion(employeeView.getVersion());
        return employee;
    }

    @Transactional
    public List<Employee> getEmployeeList(Integer tenantId) {
        return this.employeeRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
    }

    @Transactional
    public Employee getEmployee(Integer tenantId, Long id) {
        Employee employee = (Employee)this.employeeRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Employee entity found with ID (" + id + ")."));
        this.validateTenantIdParameter(tenantId, employee);
        return employee;
    }

    @Transactional
    public Boolean deleteEmployee(Integer tenantId, Long id) {
        Optional employeeOptional = this.employeeRepository.findById((Object)id);
        if (!employeeOptional.isPresent()) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (Employee)employeeOptional.get());
        this.employeeRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public Employee createEmployee(Integer tenantId, EmployeeView employeeView) {
        Employee employee = this.convertFromEmployeeView(tenantId, employeeView);
        this.validateTenantIdParameter(tenantId, employee);
        return (Employee)this.employeeRepository.save((Object)employee);
    }

    @Transactional
    public Employee updateEmployee(Integer tenantId, EmployeeView employeeView) {
        Employee newEmployee = this.convertFromEmployeeView(tenantId, employeeView);
        Employee oldEmployee = (Employee)this.employeeRepository.findById((Object)newEmployee.getId()).orElseThrow(() -> new EntityNotFoundException("Employee entity with ID (" + newEmployee.getId() + ") not found."));
        if (!oldEmployee.getTenantId().equals(newEmployee.getTenantId())) {
            throw new IllegalStateException("Employee entity with tenantId (" + oldEmployee.getTenantId() + ") cannot change tenants.");
        }
        oldEmployee.setName(newEmployee.getName());
        oldEmployee.setSkillProficiencySet(newEmployee.getSkillProficiencySet());
        oldEmployee.setContract(newEmployee.getContract());
        return (Employee)this.employeeRepository.save((Object)oldEmployee);
    }

    protected void validateTenantIdParameter(Integer tenantId, Employee employee) {
        super.validateTenantIdParameter(tenantId, (AbstractPersistable)employee);
        for (Skill skill : employee.getSkillProficiencySet()) {
            if (Objects.equals(skill.getTenantId(), tenantId)) continue;
            throw new IllegalStateException("The tenantId (" + tenantId + ") does not match the skillProficiency (" + skill + ")'s tenantId (" + skill.getTenantId() + ").");
        }
    }

    private EmployeeAvailability convertFromEmployeeAvailabilityView(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeAvailabilityView);
        Employee employee = (Employee)this.employeeRepository.findById((Object)employeeAvailabilityView.getEmployeeId()).orElseThrow(() -> new EntityNotFoundException("Employee entity with ID (" + employeeAvailabilityView.getEmployeeId() + ") not found."));
        this.validateTenantIdParameter(tenantId, employee);
        RosterState rosterState = (RosterState)this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("RosterState entity with tenantId (" + tenantId + ") not found."));
        EmployeeAvailability employeeAvailability = new EmployeeAvailability(rosterState.getTimeZone(), employeeAvailabilityView, employee);
        employeeAvailability.setState(employeeAvailabilityView.getState());
        return employeeAvailability;
    }

    @Transactional
    public EmployeeAvailabilityView getEmployeeAvailability(Integer tenantId, Long id) {
        EmployeeAvailability employeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No EmployeeAvailability entity found with ID (" + id + ")."));
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeAvailability);
        RosterState rosterState = (RosterState)this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), employeeAvailability);
    }

    @Transactional
    public EmployeeAvailabilityView createEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability employeeAvailability = this.convertFromEmployeeAvailabilityView(tenantId, employeeAvailabilityView);
        this.employeeAvailabilityRepository.save((Object)employeeAvailability);
        RosterState rosterState = (RosterState)this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), employeeAvailability);
    }

    @Transactional
    public EmployeeAvailabilityView updateEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability newEmployeeAvailability = this.convertFromEmployeeAvailabilityView(tenantId, employeeAvailabilityView);
        EmployeeAvailability oldEmployeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.findById((Object)newEmployeeAvailability.getId()).orElseThrow(() -> new EntityNotFoundException("EmployeeAvailability entity with ID (" + newEmployeeAvailability.getId() + ") not found."));
        if (!oldEmployeeAvailability.getTenantId().equals(newEmployeeAvailability.getTenantId())) {
            throw new IllegalStateException("EmployeeAvailability entity with tenantId (" + newEmployeeAvailability.getTenantId() + ") cannot change tenants.");
        }
        oldEmployeeAvailability.setEmployee(newEmployeeAvailability.getEmployee());
        oldEmployeeAvailability.setStartDateTime(newEmployeeAvailability.getStartDateTime());
        oldEmployeeAvailability.setEndDateTime(newEmployeeAvailability.getEndDateTime());
        oldEmployeeAvailability.setState(newEmployeeAvailability.getState());
        EmployeeAvailability updatedEmployeeAvailability = (EmployeeAvailability)this.employeeAvailabilityRepository.saveAndFlush((Object)oldEmployeeAvailability);
        RosterState rosterState = (RosterState)this.rosterStateRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterState entity found with tenantId (" + tenantId + ")."));
        return new EmployeeAvailabilityView(rosterState.getTimeZone(), updatedEmployeeAvailability);
    }

    @Transactional
    public Boolean deleteEmployeeAvailability(Integer tenantId, Long id) {
        Optional employeeAvailabilityOptional = this.employeeAvailabilityRepository.findById((Object)id);
        if (!employeeAvailabilityOptional.isPresent()) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeAvailabilityOptional.get());
        this.employeeAvailabilityRepository.deleteById((Object)id);
        return true;
    }
}

