/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.contract;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.service.contract.ContractService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/contract"})
@Validated
@Api(tags={"Contract"})
public class ContractController {
    private final ContractService contractService;

    public ContractController(ContractService contractService) {
        this.contractService = contractService;
        Assert.notNull((Object)contractService, (String)"contractService must not be null.");
    }

    @ApiOperation(value="Get a list of all contracts")
    @GetMapping(value={"/"})
    public ResponseEntity<List<Contract>> getContractList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity(this.contractService.getContractList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get a contract by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Contract> getContract(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.contractService.getContract(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a contract")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteContract(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.contractService.deleteContract(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new contract")
    @PostMapping(value={"/add"})
    public ResponseEntity<Contract> createContract(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ContractView contractView) {
        return new ResponseEntity((Object)this.contractService.createContract(tenantId, contractView), HttpStatus.OK);
    }

    @ApiOperation(value="Update a contract")
    @PostMapping(value={"/update"})
    public ResponseEntity<Contract> updateContract(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ContractView contractView) {
        return new ResponseEntity((Object)this.contractService.updateContract(tenantId, contractView), HttpStatus.OK);
    }
}

