/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.skill;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/skill"})
@Validated
@Api(tags={"Skill"})
public class SkillController {
    private final SkillService skillService;

    public SkillController(SkillService skillService) {
        this.skillService = skillService;
        Assert.notNull((Object)skillService, (String)"skillService must not be null.");
    }

    @ApiOperation(value="Get a list of all skills")
    @GetMapping(value={"/"})
    public ResponseEntity<List<Skill>> getSkillList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity(this.skillService.getSkillList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get a skill by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Skill> getSkill(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.skillService.getSkill(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a skill")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteSkill(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.skillService.deleteSkill(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new skill")
    @PostMapping(value={"/add"})
    public ResponseEntity<Skill> createSkill(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid SkillView skillView) {
        return new ResponseEntity((Object)this.skillService.createSkill(tenantId, skillView), HttpStatus.OK);
    }

    @ApiOperation(value="Update a skill")
    @PostMapping(value={"/update"})
    public ResponseEntity<Skill> updateSkill(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid SkillView skillView) {
        return new ResponseEntity((Object)this.skillService.updateSkill(tenantId, skillView), HttpStatus.OK);
    }
}

