/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.common.jaxrs;

import javax.persistence.EntityNotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class OptaWebExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        StringBuilder builder = new StringBuilder();
        builder.append(exception.getMessage());
        for (StackTraceElement trace : exception.getStackTrace()) {
            builder.append(trace.toString()).append('\n');
        }
        return Response.status((Response.Status)this.resolveStatus(exception)).type("text/plain").entity((Object)builder.toString()).build();
    }

    private Response.Status resolveStatus(Exception exception) {
        if (exception instanceof EntityNotFoundException) {
            return Response.Status.NOT_FOUND;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

