/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.employee;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeAvailability;
import org.optaweb.employeerostering.shared.employee.EmployeeRestService;
import org.optaweb.employeerostering.shared.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.optaweb.employeerostering.shared.skill.Skill;

public class EmployeeRestServiceImpl
extends AbstractRestServiceImpl
implements EmployeeRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RosterRestService rosterRestService;

    @Transactional
    public List<Employee> getEmployeeList(Integer tenantId) {
        return this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList();
    }

    @Transactional
    public Employee getEmployee(Integer tenantId, Long id) {
        Employee employee = (Employee)this.entityManager.find(Employee.class, (Object)id);
        this.validateTenantIdParameter(tenantId, employee);
        return employee;
    }

    @Transactional
    public Employee addEmployee(Integer tenantId, Employee employee) {
        this.validateTenantIdParameter(tenantId, employee);
        this.entityManager.persist((Object)employee);
        return employee;
    }

    @Transactional
    public Employee updateEmployee(Integer tenantId, Employee employee) {
        this.validateTenantIdParameter(tenantId, employee);
        employee = (Employee)this.entityManager.merge((Object)employee);
        return employee;
    }

    @Transactional
    public Boolean removeEmployee(Integer tenantId, Long id) {
        Employee employee = (Employee)this.entityManager.find(Employee.class, (Object)id);
        if (employee == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, employee);
        this.entityManager.remove((Object)employee);
        return true;
    }

    protected void validateTenantIdParameter(Integer tenantId, Employee employee) {
        super.validateTenantIdParameter(tenantId, (AbstractPersistable)employee);
        for (Skill skill : employee.getSkillProficiencySet()) {
            if (Objects.equals(skill.getTenantId(), tenantId)) continue;
            throw new IllegalStateException("The tenantId (" + tenantId + ") does not match the skillProficiency (" + skill + ")'s tenantId (" + skill.getTenantId() + ").");
        }
    }

    @Transactional
    public EmployeeAvailabilityView addEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability employeeAvailability = this.convertFromView(tenantId, employeeAvailabilityView);
        this.entityManager.persist((Object)employeeAvailability);
        return new EmployeeAvailabilityView(this.rosterRestService.getRosterState(tenantId).getTimeZone(), employeeAvailability);
    }

    @Transactional
    public EmployeeAvailabilityView updateEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        EmployeeAvailability employeeAvailability = this.convertFromView(tenantId, employeeAvailabilityView);
        employeeAvailability = (EmployeeAvailability)this.entityManager.merge((Object)employeeAvailability);
        this.entityManager.flush();
        return new EmployeeAvailabilityView(this.rosterRestService.getRosterState(tenantId).getTimeZone(), employeeAvailability);
    }

    private EmployeeAvailability convertFromView(Integer tenantId, EmployeeAvailabilityView employeeAvailabilityView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeAvailabilityView);
        Employee employee = (Employee)this.entityManager.find(Employee.class, (Object)employeeAvailabilityView.getEmployeeId());
        this.validateTenantIdParameter(tenantId, employee);
        EmployeeAvailability employeeAvailability = new EmployeeAvailability(this.rosterRestService.getRosterState(tenantId).getTimeZone(), employeeAvailabilityView, employee);
        employeeAvailability.setState(employeeAvailabilityView.getState());
        return employeeAvailability;
    }

    @Transactional
    public Boolean removeEmployeeAvailability(Integer tenantId, Long id) {
        EmployeeAvailability employeeAvailability = (EmployeeAvailability)this.entityManager.find(EmployeeAvailability.class, (Object)id);
        if (employeeAvailability == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)employeeAvailability);
        this.entityManager.remove((Object)employeeAvailability);
        return true;
    }
}

