/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.contract;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.contract.Contract;
import org.optaweb.employeerostering.shared.contract.ContractRestService;

public class ContractRestServiceImpl
extends AbstractRestServiceImpl
implements ContractRestService {
    @PersistenceContext
    private EntityManager entityManager;

    public List<Contract> getContractList(Integer tenantId) {
        return this.entityManager.createNamedQuery("Contract.findAll", Contract.class).setParameter("tenantId", (Object)tenantId).getResultList();
    }

    public Contract getContract(Integer tenantId, Long id) {
        Contract contract = (Contract)this.entityManager.find(Contract.class, (Object)id);
        if (contract == null) {
            throw new EntityNotFoundException("No Contract entity found with ID (" + id + ").");
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contract);
        return contract;
    }

    @Transactional
    public Contract addContract(Integer tenantId, Contract contract) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contract);
        this.entityManager.persist((Object)contract);
        return contract;
    }

    @Transactional
    public Contract updateContract(Integer tenantId, Contract contract) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contract);
        contract = (Contract)this.entityManager.merge((Object)contract);
        return contract;
    }

    @Transactional
    public Boolean removeContract(Integer tenantId, Long id) {
        Contract contract = (Contract)this.entityManager.find(Contract.class, (Object)id);
        if (contract == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)contract);
        this.entityManager.remove((Object)contract);
        return true;
    }
}

