/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class HierarchyTree<K, V> {
    private Collection<HierarchyNode> hierarchyDisjointClasses;
    private HierarchyRelation<K> hierarchyRelation;

    public HierarchyTree(HierarchyRelation<K> hierarchyRelation) {
        this.hierarchyRelation = hierarchyRelation;
        this.hierarchyDisjointClasses = new ArrayList<HierarchyNode>();
    }

    public void putInHierarchy(K key, V value) {
        HierarchyNode newChild = new HierarchyNode(key, value);
        Collection subclassesOfNewChild = this.hierarchyDisjointClasses.stream().filter(c -> this.hierarchyRelation.getHierarchyRelationshipBetween(newChild.classKey, ((HierarchyNode)c).classKey) == HierarchyRelationship.IS_ABOVE).collect(Collectors.toList());
        if (subclassesOfNewChild.isEmpty()) {
            Optional<HierarchyNode> superclassOfNewChild = this.hierarchyDisjointClasses.stream().filter(c -> this.hierarchyRelation.getHierarchyRelationshipBetween(newChild.classKey, ((HierarchyNode)c).classKey) == HierarchyRelationship.IS_BELOW).findAny();
            if (superclassOfNewChild.isPresent()) {
                superclassOfNewChild.get().addChild(newChild);
            } else {
                this.hierarchyDisjointClasses.add(newChild);
            }
        } else {
            this.hierarchyDisjointClasses.removeAll(subclassesOfNewChild);
            subclassesOfNewChild.forEach(newChild::addChild);
            this.hierarchyDisjointClasses.add(newChild);
        }
    }

    public Optional<V> getHierarchyClassValue(K key) {
        List superclassesOfItem = this.hierarchyDisjointClasses.stream().filter(c -> {
            HierarchyRelationship relationship = this.hierarchyRelation.getHierarchyRelationshipBetween(key, ((HierarchyNode)c).classKey);
            return relationship == HierarchyRelationship.IS_BELOW || relationship == HierarchyRelationship.IS_THE_SAME_AS;
        }).collect(Collectors.toList());
        if (superclassesOfItem.isEmpty()) {
            return Optional.empty();
        }
        HierarchyNode mostSpecificInstance = ((HierarchyNode)superclassesOfItem.get(0)).findHierarchyClassOf(key);
        for (HierarchyNode superclassOfItem : superclassesOfItem.subList(1, superclassesOfItem.size())) {
            HierarchyNode mostSpecificInstanceInSuperclass = superclassOfItem.findHierarchyClassOf(key);
            if (this.hierarchyRelation.getHierarchyRelationshipBetween(mostSpecificInstanceInSuperclass.classKey, mostSpecificInstance.classKey) != HierarchyRelationship.IS_BELOW) continue;
            mostSpecificInstance = mostSpecificInstanceInSuperclass;
        }
        return Optional.of(mostSpecificInstance.classValue);
    }

    public static interface HierarchyRelation<K> {
        public HierarchyRelationship getHierarchyRelationshipBetween(K var1, K var2);
    }

    public static enum HierarchyRelationship {
        IS_ABOVE,
        IS_BELOW,
        IS_THE_SAME_AS,
        HAS_NO_DIRECT_RELATION;

    }

    private class HierarchyNode {
        private K classKey;
        private V classValue;
        private Collection<HierarchyNode> hierarchySubclasses;

        public HierarchyNode(K classKey, V classValue) {
            this.classKey = classKey;
            this.classValue = classValue;
            this.hierarchySubclasses = new ArrayList<HierarchyNode>();
        }

        public void addChild(HierarchyNode newChild) {
            if (HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(newChild.classKey, this.classKey) != HierarchyRelationship.IS_BELOW) {
                throw new IllegalArgumentException("The child you tried to add (" + newChild.classKey + ") is not a desendant of root (" + this.classKey + ").");
            }
            Collection subclassesOfNewChild = this.hierarchySubclasses.stream().filter(c -> HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(newChild.classKey, c.classKey) == HierarchyRelationship.IS_ABOVE).collect(Collectors.toList());
            if (subclassesOfNewChild.isEmpty()) {
                Optional<HierarchyNode> superclassOfNewChild = this.hierarchySubclasses.stream().filter(c -> HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(newChild.classKey, c.classKey) == HierarchyRelationship.IS_BELOW).findAny();
                if (superclassOfNewChild.isPresent()) {
                    superclassOfNewChild.get().addChild(newChild);
                } else {
                    this.hierarchySubclasses.add(newChild);
                }
            } else {
                this.hierarchySubclasses.removeAll(subclassesOfNewChild);
                subclassesOfNewChild.forEach(newChild::addChild);
                this.hierarchySubclasses.add(newChild);
            }
        }

        public HierarchyNode findHierarchyClassOf(K key) {
            HierarchyRelationship classRelationship = HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(key, this.classKey);
            if (classRelationship != HierarchyRelationship.IS_BELOW && classRelationship != HierarchyRelationship.IS_THE_SAME_AS) {
                throw new IllegalArgumentException("The item (" + key + ") is not a desendant of root (" + this.classKey + ").");
            }
            List superclassesOfItem = this.hierarchySubclasses.stream().filter(c -> {
                HierarchyRelationship relationship = HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(key, c.classKey);
                return relationship == HierarchyRelationship.IS_BELOW || relationship == HierarchyRelationship.IS_THE_SAME_AS;
            }).collect(Collectors.toList());
            if (superclassesOfItem.isEmpty()) {
                return this;
            }
            HierarchyNode mostSpecificInstance = ((HierarchyNode)superclassesOfItem.get(0)).findHierarchyClassOf(key);
            for (HierarchyNode superclassOfItem : superclassesOfItem.subList(1, superclassesOfItem.size())) {
                HierarchyNode mostSpecificInstanceInSuperclass = superclassOfItem.findHierarchyClassOf(key);
                if (HierarchyTree.this.hierarchyRelation.getHierarchyRelationshipBetween(mostSpecificInstanceInSuperclass.classKey, mostSpecificInstance.classKey) != HierarchyRelationship.IS_BELOW) continue;
                mostSpecificInstance = mostSpecificInstanceInSuperclass;
            }
            return mostSpecificInstance;
        }

        public String toString() {
            return this.classKey.toString();
        }
    }
}

