/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.common.jaxrs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.optaweb.employeerostering.server.common.jaxrs.OptaWebObjectMapperResolver;
import org.optaweb.employeerostering.server.exception.ExceptionDataMapper;
import org.optaweb.employeerostering.shared.exception.ServerSideExceptionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OptaWebExceptionMapper
implements ExceptionMapper<Exception> {
    @Inject
    private OptaWebObjectMapperResolver objectMapperProvider;
    @Inject
    private ExceptionDataMapper exceptionDataMapper;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Response toResponse(Exception exception) {
        try {
            ExceptionDataMapper.ExceptionData exceptionData = this.exceptionDataMapper.getExceptionDataForExceptionClass(exception.getClass());
            return Response.status((Response.Status)exceptionData.getStatusCode()).type("application/json").entity((Object)this.getEntity(exceptionData, exception)).build();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)("There was an issue with retrieving the root cause: " + e.getMessage() + "\nMore information can be found in the server log.")).build();
        }
    }

    private String getEntity(ExceptionDataMapper.ExceptionData exceptionData, Throwable exception) throws JsonProcessingException {
        ObjectMapper objectMapper = this.objectMapperProvider.getContext(ServerSideExceptionInfo.class);
        ServerSideExceptionInfo serverSideException = exceptionData.getServerSideExceptionInfoFromException(exception);
        return objectMapper.writeValueAsString((Object)serverSideException);
    }
}

