/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.rotation.view;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.rotation.ShiftTemplate;

public class ShiftTemplateView
extends AbstractPersistable {
    private Long spotId;
    private List<Long> requiredSkillSetIdList;
    private Long rotationEmployeeId;
    private Duration durationBetweenRotationStartAndTemplateStart;
    private Duration shiftTemplateDuration;

    public ShiftTemplateView() {
    }

    public ShiftTemplateView(Integer rotationLength, ShiftTemplate shiftTemplate) {
        super(shiftTemplate);
        this.spotId = shiftTemplate.getSpot().getId();
        this.rotationEmployeeId = shiftTemplate.getRotationEmployee() != null ? shiftTemplate.getRotationEmployee().getId() : null;
        this.durationBetweenRotationStartAndTemplateStart = Duration.ofDays(shiftTemplate.getStartDayOffset().intValue()).plusSeconds(shiftTemplate.getStartTime().toSecondOfDay());
        this.shiftTemplateDuration = Duration.ofDays(shiftTemplate.getEndDayOffset() < shiftTemplate.getStartDayOffset() ? (long)rotationLength.intValue() : 0L).plusDays(shiftTemplate.getEndDayOffset() - shiftTemplate.getStartDayOffset()).plusSeconds(shiftTemplate.getEndTime().toSecondOfDay()).minusSeconds(shiftTemplate.getStartTime().toSecondOfDay());
        this.requiredSkillSetIdList = shiftTemplate.getRequiredSkillSet().stream().map(AbstractPersistable::getId).sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    public ShiftTemplateView(Integer tenantId, Long spotId, Duration durationBetweenRotationStartAndTemplateStart, Duration shiftTemplateDuration, Long rotationEmployeeId, List<Long> requiredSkillSetIdList) {
        super(tenantId);
        this.spotId = spotId;
        this.durationBetweenRotationStartAndTemplateStart = durationBetweenRotationStartAndTemplateStart;
        this.shiftTemplateDuration = shiftTemplateDuration;
        this.rotationEmployeeId = rotationEmployeeId;
        this.requiredSkillSetIdList = requiredSkillSetIdList;
    }

    public Long getSpotId() {
        return this.spotId;
    }

    public void setSpotId(Long spotId) {
        this.spotId = spotId;
    }

    public Long getRotationEmployeeId() {
        return this.rotationEmployeeId;
    }

    public void setRotationEmployeeId(Long rotationEmployeeId) {
        this.rotationEmployeeId = rotationEmployeeId;
    }

    @JsonSerialize(using=DurationSerializer.class)
    public Duration getDurationBetweenRotationStartAndTemplateStart() {
        return this.durationBetweenRotationStartAndTemplateStart;
    }

    public void setDurationBetweenRotationStartAndTemplateStart(Duration durationBetweenRotationStartAndTemplateStart) {
        this.durationBetweenRotationStartAndTemplateStart = durationBetweenRotationStartAndTemplateStart;
    }

    @JsonSerialize(using=DurationSerializer.class)
    public Duration getShiftTemplateDuration() {
        return this.shiftTemplateDuration;
    }

    public void setShiftTemplateDuration(Duration shiftTemplateDuration) {
        this.shiftTemplateDuration = shiftTemplateDuration;
    }

    public List<Long> getRequiredSkillSetIdList() {
        return this.requiredSkillSetIdList;
    }

    public void setRequiredSkillSetIdList(List<Long> requiredSkillSetIdList) {
        this.requiredSkillSetIdList = requiredSkillSetIdList;
    }
}

