/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.shift;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.PinningShiftFilter;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;

@Entity
@PlanningEntity(pinningFilter=PinningShiftFilter.class)
public class Shift
extends AbstractPersistable {
    private final AtomicLong lengthInMinutes = new AtomicLong(-1L);
    @ManyToOne
    private Employee rotationEmployee;
    @NotNull
    @ManyToOne
    private Spot spot;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="ShiftRequiredSkillSet", joinColumns={@JoinColumn(name="shiftId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> requiredSkillSet;
    @NotNull
    private OffsetDateTime startDateTime;
    @NotNull
    private OffsetDateTime endDateTime;
    @PlanningPin
    private boolean pinnedByUser = false;
    @ManyToOne
    @PlanningVariable(valueRangeProviderRefs={"employeeRange"}, nullable=true)
    private Employee employee = null;
    @ManyToOne
    private Employee originalEmployee = null;

    public Shift() {
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        this(tenantId, spot, startDateTime, endDateTime, null);
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime, Employee rotationEmployee) {
        this(tenantId, spot, startDateTime, endDateTime, rotationEmployee, new HashSet<Skill>(), null);
    }

    public Shift(Integer tenantId, Spot spot, OffsetDateTime startDateTime, OffsetDateTime endDateTime, Employee rotationEmployee, Set<Skill> requiredSkillSet, Employee originalEmployee) {
        super(tenantId);
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.spot = spot;
        this.rotationEmployee = rotationEmployee;
        this.requiredSkillSet = requiredSkillSet;
        this.originalEmployee = originalEmployee;
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot) {
        this(zoneId, shiftView, spot, null);
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot, Employee rotationEmployee) {
        this(zoneId, shiftView, spot, rotationEmployee, new HashSet<Skill>(), null);
    }

    public Shift(ZoneId zoneId, ShiftView shiftView, Spot spot, Employee rotationEmployee, Set<Skill> requiredSkillSet, Employee originalEmployee) {
        super(shiftView);
        this.startDateTime = OffsetDateTime.of(shiftView.getStartDateTime(), zoneId.getRules().getOffset(shiftView.getStartDateTime()));
        this.endDateTime = OffsetDateTime.of(shiftView.getEndDateTime(), zoneId.getRules().getOffset(shiftView.getEndDateTime()));
        this.spot = spot;
        this.pinnedByUser = shiftView.isPinnedByUser();
        this.rotationEmployee = rotationEmployee;
        this.requiredSkillSet = requiredSkillSet;
        this.originalEmployee = originalEmployee;
    }

    @AssertTrue(message="Shift's end date time is not at least 30 minutes after shift's start date time")
    public @AssertTrue(message="Shift's end date time is not at least 30 minutes after shift's start date time") boolean isValid() {
        return this.startDateTime != null && this.endDateTime != null && Duration.between(this.startDateTime, this.endDateTime).getSeconds() / 60L >= 30L;
    }

    @Override
    public String toString() {
        return this.spot + " " + this.startDateTime + "-" + this.endDateTime;
    }

    public boolean precedes(Shift other) {
        return !this.endDateTime.isAfter(other.startDateTime);
    }

    public long getLengthInMinutes() {
        long currentLengthInMinutes = this.lengthInMinutes.get();
        if (currentLengthInMinutes >= 0L) {
            return currentLengthInMinutes;
        }
        long newLengthInMinutes = this.startDateTime.until(this.endDateTime, ChronoUnit.MINUTES);
        this.lengthInMinutes.set(newLengthInMinutes);
        return newLengthInMinutes;
    }

    public boolean isMoved() {
        return this.originalEmployee != null && this.originalEmployee != this.employee;
    }

    public boolean hasRequiredSkills() {
        return this.employee.getSkillProficiencySet().containsAll(this.spot.getRequiredSkillSet()) && this.employee.getSkillProficiencySet().containsAll(this.requiredSkillSet);
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        this.lengthInMinutes.set(-1L);
    }

    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        this.lengthInMinutes.set(-1L);
    }

    public boolean isPinnedByUser() {
        return this.pinnedByUser;
    }

    public void setPinnedByUser(boolean lockedByUser) {
        this.pinnedByUser = lockedByUser;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Employee getRotationEmployee() {
        return this.rotationEmployee;
    }

    public void setRotationEmployee(Employee rotationEmployee) {
        this.rotationEmployee = rotationEmployee;
    }

    public Employee getOriginalEmployee() {
        return this.originalEmployee;
    }

    public void setOriginalEmployee(Employee originalEmployee) {
        this.originalEmployee = originalEmployee;
    }

    public Set<Skill> getRequiredSkillSet() {
        return this.requiredSkillSet;
    }

    public void setRequiredSkillSet(Set<Skill> requiredSkillSet) {
        this.requiredSkillSet = requiredSkillSet;
    }

    public Shift inTimeZone(ZoneId zoneId) {
        Shift out = new Shift(zoneId, new ShiftView(zoneId, this), this.getSpot(), this.getRotationEmployee(), this.getRequiredSkillSet(), this.getOriginalEmployee());
        out.setEmployee(this.getEmployee());
        return out;
    }
}

