/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import javax.validation.Validator;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.common.IndictmentUtils;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.optaweb.employeerostering.service.spot.SpotRepository;

@ApplicationScoped
public class ShiftService
extends AbstractRestService {
    ShiftRepository shiftRepository;
    SpotRepository spotRepository;
    SkillService skillService;
    EmployeeRepository employeeRepository;
    RosterService rosterService;
    IndictmentUtils indictmentUtils;

    @Inject
    public ShiftService(Validator validator, ShiftRepository shiftRepository, SpotRepository spotRepository, SkillService skillService, EmployeeRepository employeeRepository, RosterService rosterService, IndictmentUtils indictmentUtils) {
        super(validator);
        this.shiftRepository = shiftRepository;
        this.spotRepository = spotRepository;
        this.skillService = skillService;
        this.employeeRepository = employeeRepository;
        this.rosterService = rosterService;
        this.indictmentUtils = indictmentUtils;
    }

    public List<ShiftView> getShiftList(Integer tenantId) {
        Map<Object, Indictment<HardMediumSoftLongScore>> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId));
        return this.getAllShifts(tenantId).stream().map(s -> this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), (Shift)s, (Indictment<HardMediumSoftLongScore>)((Indictment)indictmentMap.get(s)))).collect(Collectors.toList());
    }

    private List<Shift> getAllShifts(Integer tenantId) {
        return this.shiftRepository.findAllByTenantId(tenantId);
    }

    @Transactional
    public ShiftView getShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.shiftRepository.findByIdOptional(id).orElseThrow(() -> new EntityNotFoundException("No Shift entity found with ID (" + id + ")."));
        this.validateBean(tenantId, shift);
        Indictment<HardMediumSoftLongScore> indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    private Shift convertFromView(Integer tenantId, ShiftView shiftView) {
        this.validateBean(tenantId, shiftView);
        Spot spot = (Spot)this.spotRepository.findByIdOptional(shiftView.getSpotId()).orElseThrow(() -> new EntityNotFoundException("No Spot entity found with ID (" + shiftView.getSpotId() + ")."));
        this.validateBean(tenantId, spot);
        Long rotationEmployeeId = shiftView.getRotationEmployeeId();
        Employee rotationEmployee = null;
        if (rotationEmployeeId != null) {
            rotationEmployee = (Employee)this.employeeRepository.findByIdOptional(rotationEmployeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing rotationEmployeeId (" + rotationEmployeeId + ")."));
            this.validateBean(tenantId, rotationEmployee);
        }
        Long originalEmployeeId = shiftView.getOriginalEmployeeId();
        Employee originalEmployee = null;
        if (originalEmployeeId != null) {
            originalEmployee = (Employee)this.employeeRepository.findByIdOptional(originalEmployeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing originalEmployeeId (" + originalEmployeeId + ")."));
            this.validateBean(tenantId, originalEmployee);
        }
        Set requiredSkillSet = shiftView.getRequiredSkillSetIdList().stream().map(id -> this.skillService.getSkill(tenantId, (Long)id)).collect(Collectors.toCollection(HashSet::new));
        Shift shift = new Shift(this.rosterService.getRosterState(tenantId).getTimeZone(), shiftView, spot, rotationEmployee, requiredSkillSet, originalEmployee);
        shift.setPinnedByUser(shiftView.isPinnedByUser());
        Long employeeId = shiftView.getEmployeeId();
        if (employeeId != null) {
            Employee employee = (Employee)this.employeeRepository.findByIdOptional(employeeId).orElseThrow(() -> new EntityNotFoundException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + employeeId + ")."));
            this.validateBean(tenantId, employee);
            shift.setEmployee(employee);
        }
        this.validateBean(tenantId, shift);
        return shift;
    }

    @Transactional
    public ShiftView createShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        this.shiftRepository.persist(shift);
        Indictment<HardMediumSoftLongScore> indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    @Transactional
    public ShiftView updateShift(Integer tenantId, ShiftView shiftView) {
        Shift newShift = this.convertFromView(tenantId, shiftView);
        Shift oldShift = (Shift)this.shiftRepository.findByIdOptional(newShift.getId()).orElseThrow(() -> new EntityNotFoundException("Shift entity with ID (" + newShift.getId() + ") not found."));
        if (!oldShift.getTenantId().equals(newShift.getTenantId())) {
            throw new IllegalStateException("Shift entity with tenantId (" + oldShift.getTenantId() + ") cannot change tenants.");
        }
        oldShift.setRotationEmployee(newShift.getRotationEmployee());
        oldShift.setOriginalEmployee(newShift.getOriginalEmployee());
        oldShift.setSpot(newShift.getSpot());
        oldShift.setStartDateTime(newShift.getStartDateTime());
        oldShift.setEndDateTime(newShift.getEndDateTime());
        oldShift.setPinnedByUser(newShift.isPinnedByUser());
        oldShift.setEmployee(newShift.getEmployee());
        oldShift.setRequiredSkillSet(newShift.getRequiredSkillSet());
        this.shiftRepository.persistAndFlush(oldShift);
        Indictment<HardMediumSoftLongScore> indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterService.buildRoster(tenantId)).get(oldShift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterService.getRosterState(tenantId).getTimeZone(), oldShift, indictment);
    }

    @Transactional
    public Boolean deleteShift(Integer tenantId, Long id) {
        Optional shiftOptional = this.shiftRepository.findByIdOptional(id);
        if (!shiftOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)shiftOptional.get());
        this.shiftRepository.deleteById(id);
        return true;
    }
}

