/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.panache.common.Sort;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;

@ApplicationScoped
public class EmployeeAvailabilityRepository
implements PanacheRepository<EmployeeAvailability> {
    public List<EmployeeAvailability> findAllByTenantId(Integer tenantId) {
        return this.find("tenantId", Sort.ascending((String[])new String[]{"employee.name", "startDateTime"}), new Object[]{tenantId}).list();
    }

    public void deleteForTenant(Integer tenantId) {
        this.delete("tenantId", new Object[]{tenantId});
    }

    public List<EmployeeAvailability> filterWithEmployee(Integer tenantId, Set<Employee> employeeSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (employeeSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and employee in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"employee.name", "startDateTime"}), new Object[]{tenantId, employeeSet, startDateTime, endDateTime}).list();
    }
}

