/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.util.ShiftRosterXlsxFileIO;

@Path(value="/rest/tenant/{tenantId}/roster")
@ApplicationScoped
@Tag(name="Roster")
public class RosterController {
    private final RosterService rosterService;
    private final SpotRepository spotRepository;

    @Inject
    public RosterController(RosterService rosterService, SpotRepository spotRepository) {
        this.rosterService = rosterService;
        this.spotRepository = spotRepository;
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get Roster State", description="Get the Roster State for a tenant")
    public RosterState getRosterState(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.rosterService.getRosterState(tenantId);
    }

    @GET
    @Path(value="/shiftRosterView/current")
    @Operation(summary="Current Shift Roster", description="Get the current shift roster view")
    public ShiftRosterView getCurrentShiftRosterView(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="p") Integer pageNumber, @QueryParam(value="n") Integer numberOfItemsPerPage) {
        return this.rosterService.getCurrentShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage);
    }

    @GET
    @Path(value="/shiftRosterView")
    @Operation(summary="View Shift Roster", description="Get a shift roster view between two dates")
    public ShiftRosterView getShiftRosterView(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="p") Integer pageNumber, @QueryParam(value="n") Integer numberOfItemsPerPage, @QueryParam(value="startDate") String startDateString, @QueryParam(value="endDate") String endDateString) {
        if (startDateString == null) {
            throw new IllegalArgumentException("query parameter startDate is required");
        }
        if (endDateString == null) {
            throw new IllegalArgumentException("query parameter endDate is required");
        }
        return this.rosterService.getShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString);
    }

    @POST
    @Path(value="/shiftRosterView/for")
    @Operation(summary="View Shift Roster For Spots", description="Get a shift roster view between two dates for a subset of the spots")
    public ShiftRosterView getShiftRosterViewFor(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="startDate") String startDateString, @QueryParam(value="endDate") String endDateString, @Valid List<Spot> spots) {
        if (startDateString == null) {
            throw new IllegalArgumentException("query parameter startDate is required");
        }
        if (endDateString == null) {
            throw new IllegalArgumentException("query parameter endDate is required");
        }
        return this.rosterService.getShiftRosterViewFor(tenantId, startDateString, endDateString, spots);
    }

    @GET
    @Path(value="/shiftRosterView/excel")
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    @Operation(summary="Export Shift Roster", description="Get a shift roster view between two dates for a subset of the spots as an excel file")
    public Response getShiftRosterViewAsExcel(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="startDate") String startDateString, @QueryParam(value="endDate") String endDateString, @QueryParam(value="spotList") String spotListString) {
        if (startDateString == null) {
            throw new IllegalArgumentException("query parameter startDate is required");
        }
        if (endDateString == null) {
            throw new IllegalArgumentException("query parameter endDate is required");
        }
        if (spotListString == null) {
            throw new IllegalArgumentException("query parameter spotList is required");
        }
        Set spotIdSet = Arrays.stream(spotListString.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        List<Spot> spotList = this.spotRepository.findAllByTenantId(tenantId).stream().filter(s -> spotIdSet.contains(s.getId())).collect(Collectors.toList());
        if (spotList.size() != spotIdSet.size()) {
            return Response.noContent().status(Response.Status.BAD_REQUEST).build();
        }
        ShiftRosterView shiftRosterView = this.rosterService.getShiftRosterViewFor(tenantId, startDateString, endDateString, spotList);
        try {
            String fileName = "Roster-" + startDateString + "--" + endDateString + ".xlsx";
            return Response.ok((Object)ShiftRosterXlsxFileIO.getExcelBytesForShiftRoster(shiftRosterView)).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
        }
        catch (IOException e) {
            return Response.noContent().status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/availabilityRosterView/current")
    @Operation(summary="Current Availability Roster", description="Get the current availability roster view")
    public AvailabilityRosterView getCurrentAvailabilityRosterView(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="p") Integer pageNumber, @QueryParam(value="n") Integer numberOfItemsPerPage) {
        return this.rosterService.getCurrentAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage);
    }

    @GET
    @Path(value="/availabilityRosterView")
    @Operation(summary="View Availability Roster", description="Get an availability roster view between two dates")
    public AvailabilityRosterView getAvailabilityRosterView(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="p") Integer pageNumber, @QueryParam(value="n") Integer numberOfItemsPerPage, @QueryParam(value="startDate") String startDateString, @QueryParam(value="endDate") String endDateString) {
        if (startDateString == null) {
            throw new IllegalArgumentException("query parameter startDate is required");
        }
        if (endDateString == null) {
            throw new IllegalArgumentException("query parameter endDate is required");
        }
        return this.rosterService.getAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString);
    }

    @POST
    @Path(value="/availabilityRosterView/for")
    @Operation(summary="Availability Roster For Employees", description="Get an availability roster view between two dates for a subset of the employees")
    public AvailabilityRosterView getAvailabilityRosterViewFor(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="startDate") String startDateString, @QueryParam(value="endDate") String endDateString, @Valid List<Employee> employees) {
        if (startDateString == null) {
            throw new IllegalArgumentException("query parameter startDate is required");
        }
        if (endDateString == null) {
            throw new IllegalArgumentException("query parameter endDate is required");
        }
        return this.rosterService.getAvailabilityRosterViewFor(tenantId, startDateString, endDateString, employees);
    }

    @POST
    @Path(value="/solve")
    @Operation(summary="Solve Roster", description="Start solving the roster. This will assign each shift to an employee")
    public void solveRoster(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.solveRoster(tenantId);
    }

    @POST
    @Path(value="/replan")
    @Operation(summary="Replan Roster", description="Start solving the roster in Nondisruptive mode. This will modify the published schedule to make it feasible with minimal changes.")
    public void replanRoster(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.replanRoster(tenantId);
    }

    @POST
    @Path(value="/terminate")
    @Operation(summary="Terminate Solver", description="Stop solving the roster, if it hasn't terminated automatically already")
    public void terminateRosterEarly(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.terminateRosterEarly(tenantId);
    }

    @GET
    @Path(value="/status")
    @Operation(summary="Solver Status", description="Get the status of the Solver")
    public SolverStatus getSolverStatus(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.rosterService.getSolverStatus(tenantId);
    }

    @POST
    @Path(value="/provision")
    @Operation(summary="Provision Shifts", description="Provision shifts from particular time buckets into the given period")
    public void provision(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @QueryParam(value="startRotationOffset") Integer startRotationOffset, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, List<Long> timeBucketIdList) {
        if (startRotationOffset == null) {
            throw new IllegalArgumentException("query parameter startRotationOffset is required");
        }
        if (fromDate == null) {
            throw new IllegalArgumentException("query parameter fromDate is required");
        }
        if (toDate == null) {
            throw new IllegalArgumentException("query parameter toDate is required");
        }
        this.rosterService.provision(tenantId, startRotationOffset, LocalDate.parse(fromDate), LocalDate.parse(toDate), timeBucketIdList);
    }

    @POST
    @Path(value="/publishAndProvision")
    @Operation(summary="Publish and Provision", description="Publish the next set of draft shifts and create new draft shifts from the rotation template")
    public PublishResult publishAndProvision(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.rosterService.publishAndProvision(tenantId);
    }

    @POST
    @Path(value="/commitChanges")
    @Operation(summary="Commit Changes", description="Updates the original employee to match adjusted schedule; essentially a republish without provision")
    public void commitChanges(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.commitChanges(tenantId);
    }
}

