/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.solver;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.tenant.RosterConstraintConfiguration;

public final class EmployeeRosteringConstraintProvider
implements ConstraintProvider {
    private static BiConstraintStream<EmployeeAvailability, Shift> getConstraintStreamWithAvailabilityIntersections(ConstraintFactory constraintFactory, EmployeeAvailabilityState employeeAvailabilityState) {
        return constraintFactory.forEach(EmployeeAvailability.class).filter(employeeAvailability -> employeeAvailability.getState() == employeeAvailabilityState).join(Shift.class, Joiners.equal(EmployeeAvailability::getEmployee, Shift::getEmployee), Joiners.lessThan(EmployeeAvailability::getStartDateTime, Shift::getEndDateTime), Joiners.greaterThan(EmployeeAvailability::getEndDateTime, Shift::getStartDateTime));
    }

    private static LocalDate extractFirstDayOfWeek(DayOfWeek weekStarting, OffsetDateTime date) {
        return date.with(TemporalAdjusters.previousOrSame(weekStarting)).toLocalDate();
    }

    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredSkillForShift(constraintFactory), this.unavailableEmployeeTimeSlot(constraintFactory), this.noOverlappingShifts(constraintFactory), this.noMoreThanTwoConsecutiveShifts(constraintFactory), this.breakBetweenNonConsecutiveShiftsIsAtLeastTenHours(constraintFactory), this.dailyMinutesMustNotExceedContractMaximum(constraintFactory), this.weeklyMinutesMustNotExceedContractMaximum(constraintFactory), this.monthlyMinutesMustNotExceedContractMaximum(constraintFactory), this.yearlyMinutesMustNotExceedContractMaximum(constraintFactory), this.assignEveryShift(constraintFactory), this.employeeIsNotOriginalEmployee(constraintFactory), this.undesiredEmployeeTimeSlot(constraintFactory), this.desiredEmployeeTimeSlot(constraintFactory), this.employeeNotRotationEmployee(constraintFactory)};
    }

    Constraint requiredSkillForShift(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shift.class).filter(shift -> !shift.hasRequiredSkills()).penalizeConfigurableLong("Required skill for a shift", Shift::getLengthInMinutes);
    }

    Constraint unavailableEmployeeTimeSlot(ConstraintFactory constraintFactory) {
        return EmployeeRosteringConstraintProvider.getConstraintStreamWithAvailabilityIntersections(constraintFactory, EmployeeAvailabilityState.UNAVAILABLE).penalizeConfigurableLong("Unavailable time slot for an employee", (employeeAvailability, shift) -> shift.getLengthInMinutes());
    }

    Constraint noOverlappingShifts(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(Shift.class, Joiners.equal(Shift::getEmployee), Joiners.overlapping(Shift::getStartDateTime, Shift::getEndDateTime)).penalizeConfigurableLong("No overlapping shifts", (shift, otherShift) -> otherShift.getLengthInMinutes());
    }

    Constraint noMoreThanTwoConsecutiveShifts(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shift.class).join(Shift.class, Joiners.equal(Shift::getEmployee), Joiners.equal(Shift::getEndDateTime, Shift::getStartDateTime)).join(Shift.class, Joiners.equal((s1, s2) -> s2.getEmployee(), Shift::getEmployee), Joiners.equal((s1, s2) -> s2.getEndDateTime(), Shift::getStartDateTime)).penalizeConfigurableLong("No more than 2 consecutive shifts", (s1, s2, s3) -> s3.getLengthInMinutes());
    }

    Constraint breakBetweenNonConsecutiveShiftsIsAtLeastTenHours(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shift.class).join(Shift.class, Joiners.equal(Shift::getEmployee), Joiners.lessThan(Shift::getEndDateTime, Shift::getStartDateTime)).filter((s1, s2) -> !Objects.equals(s1, s2)).filter((s1, s2) -> s1.getEndDateTime().until(s2.getStartDateTime(), ChronoUnit.HOURS) < 10L).penalizeConfigurableLong("Break between non-consecutive shifts is at least 10 hours", (s1, s2) -> {
            long breakLength = s1.getEndDateTime().until(s2.getStartDateTime(), ChronoUnit.MINUTES);
            return 600L - breakLength;
        });
    }

    Constraint dailyMinutesMustNotExceedContractMaximum(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> employee.getContract().getMaximumMinutesPerDay() != null).join(Shift.class, Joiners.equal(Function.identity(), Shift::getEmployee)).groupBy((employee, shift) -> employee, (employee, shift) -> shift.getStartDateTime().toLocalDate(), ConstraintCollectors.sumDuration((employee, shift) -> Duration.between(shift.getStartDateTime(), shift.getEndDateTime()))).filter((employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() > (long)employee.getContract().getMaximumMinutesPerDay().intValue()).penalizeConfigurableLong("Daily minutes must not exceed contract maximum", (employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() - (long)employee.getContract().getMaximumMinutesPerDay().intValue());
    }

    Constraint weeklyMinutesMustNotExceedContractMaximum(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(RosterConstraintConfiguration.class).join(Employee.class).filter((configuration, employee) -> employee.getContract().getMaximumMinutesPerWeek() != null).join(Shift.class, Joiners.equal((configuration, employee) -> employee, Shift::getEmployee)).groupBy((configuration, employee, shift) -> employee, (configuration, employee, shift) -> EmployeeRosteringConstraintProvider.extractFirstDayOfWeek(configuration.getWeekStartDay(), shift.getStartDateTime()), ConstraintCollectors.sumDuration((configuration, employee, shift) -> Duration.between(shift.getStartDateTime(), shift.getEndDateTime()))).filter((employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() > (long)employee.getContract().getMaximumMinutesPerWeek().intValue()).penalizeConfigurableLong("Weekly minutes must not exceed contract maximum", (employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() - (long)employee.getContract().getMaximumMinutesPerWeek().intValue());
    }

    Constraint monthlyMinutesMustNotExceedContractMaximum(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> employee.getContract().getMaximumMinutesPerMonth() != null).join(Shift.class, Joiners.equal(Function.identity(), Shift::getEmployee)).groupBy((employee, shift) -> employee, (employee, shift) -> YearMonth.from(shift.getStartDateTime()), ConstraintCollectors.sumDuration((employee, shift) -> Duration.between(shift.getStartDateTime(), shift.getEndDateTime()))).filter((employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() > (long)employee.getContract().getMaximumMinutesPerMonth().intValue()).penalizeConfigurableLong("Monthly minutes must not exceed contract maximum", (employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() - (long)employee.getContract().getMaximumMinutesPerMonth().intValue());
    }

    Constraint yearlyMinutesMustNotExceedContractMaximum(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Employee.class).filter(employee -> employee.getContract().getMaximumMinutesPerYear() != null).join(Shift.class, Joiners.equal(Function.identity(), Shift::getEmployee)).groupBy((employee, shift) -> employee, (employee, shift) -> shift.getStartDateTime().getYear(), ConstraintCollectors.sumDuration((employee, shift) -> Duration.between(shift.getStartDateTime(), shift.getEndDateTime()))).filter((employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() > (long)employee.getContract().getMaximumMinutesPerYear().intValue()).penalizeConfigurableLong("Yearly minutes must not exceed contract maximum", (employee, firstDayOfWeek, totalWorkingTime) -> totalWorkingTime.toMinutes() - (long)employee.getContract().getMaximumMinutesPerYear().intValue());
    }

    Constraint assignEveryShift(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachIncludingNullVars(Shift.class).filter(shift -> shift.getEmployee() == null).penalizeConfigurable("Assign every shift");
    }

    Constraint employeeIsNotOriginalEmployee(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shift.class).filter(shift -> shift.getOriginalEmployee() != null).filter(shift -> !Objects.equals(shift.getEmployee(), shift.getOriginalEmployee())).penalizeConfigurableLong("Employee is not original employee", Shift::getLengthInMinutes);
    }

    Constraint undesiredEmployeeTimeSlot(ConstraintFactory constraintFactory) {
        return EmployeeRosteringConstraintProvider.getConstraintStreamWithAvailabilityIntersections(constraintFactory, EmployeeAvailabilityState.UNDESIRED).penalizeConfigurableLong("Undesired time slot for an employee", (employeeAvailability, shift) -> employeeAvailability.getDuration().toMinutes());
    }

    Constraint desiredEmployeeTimeSlot(ConstraintFactory constraintFactory) {
        return EmployeeRosteringConstraintProvider.getConstraintStreamWithAvailabilityIntersections(constraintFactory, EmployeeAvailabilityState.DESIRED).rewardConfigurableLong("Desired time slot for an employee", (employeeAvailability, shift) -> employeeAvailability.getDuration().toMinutes());
    }

    Constraint employeeNotRotationEmployee(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(Shift.class).filter(shift -> shift.getRotationEmployee() != null && shift.getRotationEmployee() != shift.getEmployee()).penalizeConfigurableLong("Employee is not rotation employee", Shift::getLengthInMinutes);
    }
}

