/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.contract;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.service.contract.ContractService;

@Path(value="/rest/tenant/{tenantId}/contract")
@ApplicationScoped
@Tag(name="Contract")
public class ContractController {
    private final ContractService contractService;

    @Inject
    public ContractController(ContractService contractService) {
        this.contractService = contractService;
    }

    @Operation(summary="List Contracts", description="Get a list of all contracts")
    @GET
    @Path(value="/")
    public List<Contract> getContractList(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return this.contractService.getContractList(tenantId);
    }

    @Operation(summary="Get Contract", description="Get a contract by id")
    @GET
    @Path(value="/{id}")
    public Contract getContract(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.contractService.getContract(tenantId, id);
    }

    @Operation(summary="Delete Contract", description="Deletes a contract")
    @DELETE
    @Path(value="/{id}")
    public Boolean deleteContract(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @PathParam(value="id") @Min(value=0L) @Min(value=0L) Long id) {
        return this.contractService.deleteContract(tenantId, id);
    }

    @Operation(summary="Add Contract", description="Adds a contract")
    @POST
    @Path(value="/add")
    public Contract createContract(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid ContractView contractView) {
        return this.contractService.createContract(tenantId, contractView);
    }

    @Operation(summary="Update Contract", description="Updates a contract")
    @POST
    @Path(value="/update")
    public Contract updateContract(@PathParam(value="tenantId") @Min(value=0L) @Min(value=0L) Integer tenantId, @Valid ContractView contractView) {
        return this.contractService.updateContract(tenantId, contractView);
    }
}

